<?php
	/**
     * Add Custom Templates to page template array
     */
	if( !function_exists('dtlms_registration_template')){
	    function dtlms_reg_template_attribute($templates) {
	        $templates = array_merge($templates, array(
	            'registration.php' => esc_html__('Registration', 'dtlms') ,
	        ));
	        return $templates;
	    }
	    add_filter ( 'theme_page_templates',  'dtlms_reg_template_attribute' );
	}

 	/**
     * Include Custom Templates page from plugin
     */

    if( !function_exists('dtlms_registration_template')){
    	function dtlms_registration_template($template){
            global $post;
            $id = get_the_ID();
            $file = get_post_meta($id, '_wp_page_template', true);
            if ('registration.php' == $file){
                $template = DTLMS_PLUGIN_PATH . 'custom-post-types/templates/registration.php';
            }
        	return $template;
   		 }
         add_filter ( 'template_include','dtlms_registration_template', 99 , 1 );

    }


    /**
     * User Registration Save Data
     */

	add_action('wp_ajax_dtlms_register_user_front_end', 'dtlms_register_user_front_end', 0);
	add_action('wp_ajax_nopriv_dtlms_register_user_front_end', 'dtlms_register_user_front_end');

    function dtlms_register_user_front_end() {

        $first_name = isset( $_POST['first_name'] ) ? dtlms_recursive_sanitize_text_field($_POST['first_name']) : '';
        $last_name  = isset( $_POST['last_name'] )  ? dtlms_recursive_sanitize_text_field($_POST['last_name'])  : '';
        $password   = isset( $_POST['password'] )   ? dtlms_recursive_sanitize_text_field($_POST['password'] )  : '';
        $user_name  = isset( $_POST['user_name'] )  ? dtlms_recursive_sanitize_text_field($_POST['user_name'])  : '';
        $user_email = isset( $_POST['user_email'] ) ? dtlms_recursive_sanitize_text_field($_POST['user_email']) : '';
        $user_role  = isset( $_POST['userrole'] )   ? dtlms_recursive_sanitize_text_field($_POST['userrole'] )  : '';
            $user = array(
                'user_login'  =>  $user_name,
                'user_email'  =>  $user_email,
                'user_pass'   =>  $password,
                'first_name'  =>  $first_name,
                'last_name'   =>  $last_name,
                'role'   	  =>  $user_role,
            );
		$result = wp_insert_user( $user );
        if (!is_wp_error($result)) {
            echo 'Your registration is completed successfully! To get your credential please check you mail!.';
            $dtlms_to = $user_email;
            $dtlms_subject = 'Welcome to Our Website';
            
           // Email content
           $dtlms_body =  "Hello $user_name, <br><br>";
           $dtlms_body .= "Welcome to our website! Here are your account details: <br>";
           $dtlms_body .= "Username: $user_name <br>";
           $dtlms_body .= "Password: $password <br>";
           $dtlms_body .= "Please log in using this information and consider changing your password for security reasons. <br><br>";
           $dtlms_body .= "Thank you for joining us! <br>";
           $dtlms_body .= "Best regards, <br>";
           $dtlms_body .= get_site_url();
           $dtlms_headers = array('Content-Type: text/html; charset=UTF-8');

            wp_mail($dtlms_to, $dtlms_subject, $dtlms_body, $dtlms_headers);
        } else {
            echo 'Error creating user: ' . $result->get_error_message();
        }
        wp_die();

	}
