<?php
/*Template Name: Login Template */

get_header('dtdtlms');

?>
	<div class="container">
		<div class="dtlms-column dt-sc-full-width  wdt-registration-form">
            <div class="dtlms-sc-border-title"> <h2><span><?php esc_html_e('Register Form', 'dtlms');?></span> </h2></div>

            <div class="dtlms-register-alert"></div>

			<p> <strong><?php esc_html_e('Do not have an account? Register here', 'dtlms');?></strong> </p>

			<form name="loginform" id="loginform" action="<?php echo wp_registration_url(); ?>" method="post">

				<p>
					<label><?php esc_html_e('Firstname', 'dtlms');?><span class="required"> * </span> </label>
					<input type="text" name="first_name"  id="first_name" class="input" value="" size="20" required="required"  />
				</p>
				<p>
					<label><?php esc_html_e('Lastname', 'dtlms');?><span class="required"> * </span> </label>
					<input type="text" name="last_name" id="last_name"  class="input" value="" size="20" required="required" />
				</p>
				<p>
					<label><?php esc_html_e('Username', 'dtlms');?><span class="required"> * </span> </label>
					<input type="text" name="user_name" id="user_name"  class="input" value="" size="20" required="required" />
				</p>
				<p>
					<label><?php esc_html_e('Email Id', 'dtlms');?><span class="required"> * </span> </label>
					<input type="email" name="user_email" id="user_email"  class="input" value="" size="20" required="required" />
				</p>
				<p>
					<label><?php esc_html_e('Password', 'dtlms');?><span class="required"> * </span> </label>
					<input type="password" name="password" id="password"  class="input" value="" size="20" required="required" />
				</p>
				<p>
					<label><?php esc_html_e('Confirm Password', 'dtlms');?><span class="required"> * </span> </label>
					<input type="password" name="cpassword" id="cpassword"  class="input" value="" size="20" required="required"/>
					<span class="password-alert"></span>
				</p>
				<p>
					<label><?php esc_html_e('Role', 'dtlms');?><span class="required"> * </span> </label>
                    <select name="role" id="role" required="required">
                        <option value="student"><?php echo esc_html__('Student', 'dtlms'); ?></option>
                        <option value="teacher"><?php echo esc_html__('Instructor', 'dtlms'); ?></option>
                    </select>
				</p>
				<?php do_action( 'anr_captcha_form_field' ); ?>
				<p> <?php  echo apply_filters('dt_sc_reg_form_elements', '', array () ); ?> </p>
				<p class="submit"><input type="submit" class="button-primary" id='dtlms_inssubmit' value="<?php esc_attr_e('Register', 'dtlms');?>" /></p>
				<p><?php echo esc_html__('Already have an account.?', 'dtlms'); ?> <a href="#" title=<?php echo esc_html__('Login', 'dtlms'); ?> class="dtlms-login-link" onclick="return false"><?php echo esc_html__('Login', 'dtlms'); ?></a></p>
			</form>
		</div><!-- Registration Form End -->
	</div>


<?php get_footer('dtdtlms');


?>