<?php
/**
 * Single Event Meta (Venue) Template
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe-events/modules/meta/venue.php
 *
 * @package TribeEventsCalendar
 * @version 4.6.19
 */

if ( ! tribe_get_venue_id() ) {
	return;
}

$phone   = tribe_get_phone();
$website = tribe_get_venue_website_link();
$website_title = tribe_events_get_venue_website_title();

?>

<div class="tribe-events-meta-group tribe-events-meta-group-venue">
	<h2 class="tribe-events-single-section-title"> <?php esc_html( tribe_get_venue_label_singular(), 'onekorse' ) ?> </h2>
	<dl>
		<?php do_action( 'tribe_events_single_meta_venue_section_start' ) ?>

		<dd class="tribe-venue"> <?php echo tribe_get_venue() ?> </dd>

		<?php if ( tribe_address_exists() ) : ?>
			<dd class="tribe-venue-location">
				<address class="tribe-events-address">
					<?php echo tribe_get_full_address(); ?>

					<?php if ( tribe_show_google_map_link() ) : ?>
						<?php echo tribe_get_map_link_html(); ?>
					<?php endif; ?>
				</address>
			</dd>
		<?php endif; ?>

		<?php if ( ! empty( $phone ) ): ?>
			<dt class="tribe-venue-tel-label"> <?php esc_html( 'Phone:', 'onekorse' ) ?> </dt>
			<dd class="tribe-venue-tel"> <?php echo esc_html ( $phone ) ?> </dd>
		<?php endif ?>

		<?php if ( ! empty( $website ) ): ?>
			<?php if ( ! empty( $website_title ) ): ?>
				<dt class="tribe-venue-url-label"> <?php echo esc_html( $website_title ) ?> </dt>
			<?php endif ?>
			<dd class="tribe-venue-url"> <?php echo esc_html( $website ) ?> </dd>
		<?php endif ?>

		<?php do_action( 'tribe_events_single_meta_venue_section_end' ) ?>
	</dl>
</div>
