<?php

/**
 * Listing Options - Product Thumb Content
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'OneKorse_Woo_Listing_Option_Thumb_Element_Group' ) ) {

    class OneKorse_Woo_Listing_Option_Thumb_Element_Group extends OneKorse_Woo_Listing_Option_Core {

        private static $_instance = null;

        public $option_slug;

        public $option_name;

        public $option_type;

        public $option_default_value;

        public $option_value_prefix;

        public static function instance() {

            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;

        }

        function __construct() {

            $this->option_slug          = 'product-thumb-element-group';
            $this->option_name          = esc_html__('Element Group Content', 'onekorse');
            $this->option_type          = array ( 'html', 'value-css' );
            $this->option_default_value = '';
            $this->option_value_prefix  = '';

            $this->render_backend();
        }

        /**
         * Backend Render
         */
        function render_backend() {

            /* Custom Product Templates - Options */
            add_filter( 'onekorse_woo_custom_product_template_thumb_options', array( $this, 'woo_custom_product_template_thumb_options'), 55, 1 );
        }

        /**
         * Custom Product Templates - Options
         */
        function woo_custom_product_template_thumb_options( $template_options ) {

            array_push( $template_options, $this->setting_args() );

            return $template_options;
        }

        /**
         * Settings Group
         */
        function setting_group() {
            return 'thumb';
        }

        /**
         * Setting Arguments
         */
        function setting_args() {

            $settings            =  array ();
            $settings['id']      =  $this->option_slug;
            $settings['type']    =  'sorter';
            $settings['title']   =  $this->option_name;
            $settings['default'] =  array (
                'enabled' => array(
                    'title' => esc_html__('Title', 'onekorse'),
                    'price' => esc_html__('Price', 'onekorse'),
                ),
                'disabled'         => array(
                    'cart'           => esc_html__('Cart', 'onekorse'),
                    'wishlist'       => esc_html__('Wishlist', 'onekorse'),
                    'compare'        => esc_html__('Compare', 'onekorse'),
                    'quickview'      => esc_html__('Quick View', 'onekorse'),
                    'category'       => esc_html__('Category', 'onekorse'),
                    'button_element' => esc_html__('Button Element', 'onekorse'),
                    'icons_group'    => esc_html__('Icons Group', 'onekorse'),
                    'excerpt'        => esc_html__('Excerpt', 'onekorse'),
                    'rating'         => esc_html__('Rating', 'onekorse'),
                    'separator'      => esc_html__('Separator', 'onekorse')
                ),
            );
            $settings['enabled_title']  =  esc_html__('Active Elements', 'onekorse');
            $settings['disabled_title'] =  esc_html__('Deatcive Elements', 'onekorse');

            return $settings;
        }
    }

}

if( !function_exists('onekorse_woo_listing_option_thumb_element_group') ) {
	function onekorse_woo_listing_option_thumb_element_group() {
		return OneKorse_Woo_Listing_Option_Thumb_Element_Group::instance();
	}
}

onekorse_woo_listing_option_thumb_element_group();