<?php
/**
 * Recommends plugins for use with the theme via the TGMA Script
 *
 * @package OneKorse WordPress theme
 */

function onekorse_tgmpa_plugins_register() {

	// Get array of recommended plugins.
	$plugins_list = array(
        array(
            'name'               => esc_html__('OneKorse Plus', 'onekorse'),
            'slug'               => 'onekorse-plus',
            'source'             => ONEKORSE_MODULE_DIR . '/plugins/onekorse-plus.zip',
            'required'           => true,
            'version'            => '1.0.1',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'               => esc_html__('OneKorse Pro', 'onekorse'),
            'slug'               => 'onekorse-pro',
            'source'             => ONEKORSE_MODULE_DIR . '/plugins/onekorse-pro.zip',
            'required'           => true,
            'version'            => '1.0.2',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'               => esc_html__('WeDesigntech LMS Addon', 'onekorse'),
            'slug'               => 'wedesigntech-lms-addon',
            'source'             => ONEKORSE_MODULE_DIR . '/plugins/wedesigntech-lms-addon.zip',
            'required'           => true,
            'version'            => '1.0.4',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'     => esc_html__('Elementor', 'onekorse'),
            'slug'     => 'elementor',
            'required' => true,
        ),
        array(
            'name'               => esc_html__('WeDesignTech Elementor Addon', 'onekorse'),
            'slug'               => 'wedesigntech-elementor-addon',
            'source'             => ONEKORSE_MODULE_DIR . '/plugins/wedesigntech-elementor-addon.zip',
            'required'           => true,
            'version'            => '1.0.3',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'               => esc_html__('WeDesignTech Portfolio', 'onekorse'),
            'slug'               => 'wedesigntech-portfolio',
            'source'             => ONEKORSE_MODULE_DIR . '/plugins/wedesigntech-portfolio.zip',
            'required'           => false,
            'version'            => '1.0.1',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'               => esc_html__('WDT demo importer', 'onekorse'),
            'slug'               => 'wdt-demo-importer',
            'source'             => ONEKORSE_MODULE_DIR . '/plugins/wdt-demo-importer.zip',
            'required'           => false,
            'version'            => '1.0.0',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'     => esc_html__('WooCommerce', 'onekorse'),
            'slug'     => 'woocommerce',
            'required' => false,
        ),
        array(
            'name'               => esc_html__('OneKorse Shop', 'onekorse'),
            'slug'               => 'onekorse-shop',
            'source'             => ONEKORSE_MODULE_DIR . '/plugins/onekorse-shop.zip',
            'required'           => false,
            'version'            => '1.0.1',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'     => esc_html__('YITH WooCommerce Wishlist', 'onekorse'),
            'slug'     => 'yith-woocommerce-wishlist',
            'required' => false,
        ),
        array(
            'name'     => esc_html__('YITH WooCommerce Compare', 'onekorse'),
            'slug'     => 'yith-woocommerce-compare',
            'required' => false,
        ),
        array(
            'name'     => esc_html__('Contact Form 7', 'onekorse'),
            'slug'     => 'contact-form-7',
            'required' => false,
        )
	);

	$plugins = apply_filters('onekorse_required_plugins_list', $plugins_list);

	// Register notice
	tgmpa( $plugins, array(
		'id'           => 'onekorse_theme',
		'domain'       => 'onekorse',
		'menu'         => 'install-required-plugins',
		'has_notices'  => true,
		'is_automatic' => true,
		'dismissable'  => true,
	) );

}
add_action( 'tgmpa_register', 'onekorse_tgmpa_plugins_register' );