<?php

// Register user roles
if(!function_exists('dtlms_user_roles')) {

    function dtlms_user_roles() {

		$instructor_capability=array(
			'delete_posts'=> true,
			'delete_published_posts'=> true,
			'edit_posts'=> true,
			'manage_categories' => true,
			'edit_published_posts'=> true,
			'publish_posts'=> true,
			'read' => true,
			'upload_files'=> true,
			'unfiltered_html'=> true,
			'level_1' => true
		);

		$student_capability=array(
			'read'
		);

		add_role( 'instructor', esc_html__('Instructor','dtlms'), $instructor_capability);
		add_role( 'student', esc_html__('Student','dtlms'), $student_capability );

	}

	add_action('init','dtlms_user_roles');

}


// Remove admin bar
if(!function_exists('dtlms_remove_admin_bar')) {

    function dtlms_remove_admin_bar() {
        if (!current_user_can('edit_posts')) {
         	show_admin_bar(false);
        }
    }

    add_action('after_setup_theme', 'dtlms_remove_admin_bar');

}

// Register user profile fields
add_action( 'show_user_profile', 'dtlms_social_links_sc' );
add_action( 'edit_user_profile', 'dtlms_social_links_sc' );
function dtlms_social_links_sc( $user )
{

	$sociables = array('fa-dribbble' => 'Dribble', 'fa-flickr' => 'Flickr', 'fa-github' => 'GitHub', 'fa-pinterest-p' => 'Pinterest', 'fa-stack-overflow' => 'Stack Overflow', 'fa-twitter' => 'Twitter', 'fa-youtube' => 'YouTube', 'fa-android' => 'Android', 'fa-dropbox' => 'Dropbox', 'fa-instagram' => 'Instagram', 'fa-facebook-f' => 'Facebook', 'fa-google-plus-g' => 'Google Plus', 'fa-linkedin-in' => 'LinkedIn', 'fa-skype' => 'Skype', 'fa-tumblr' => 'Tumblr', 'fa-vimeo-square' => 'Vimeo');


	echo '<h2>'.esc_html__('Author additional information','dtlms').'</h2>';

	echo '<table class="form-table">
			<tbody>

				<tr class="user-description-wrap">
					<th>'.esc_html__('Specialization', 'dtlms').'</th>
					<td>';
						$user_specialization = get_the_author_meta('user-specialization', $user->ID);
						$user_specialization = isset($user_specialization) ? $user_specialization : '';
						echo '<input class="large" type="text" placeholder="'.esc_html__('Specialization', 'dtlms').'" style="width:80%" id="user-specialization" name="user-specialization" value="'.$user_specialization.'" />
					</td>
				</tr>
				

				<tr class="user-description-wrap">
					<th>'.esc_html__('Template ID', 'dtlms').'</th>
					<td>';
						$user_template_id = get_the_author_meta('user-tempalte-id', $user->ID);
						$user_template_id = isset($user_template_id) ? $user_template_id : '';
						echo '<input class="large" type="text" placeholder="'.esc_html__('Instructor Template ID', 'dtlms').'" style="width:80%" id="user-tempalte-id" name="user-tempalte-id" value="'.$user_template_id.'" />
					</td>
				</tr>

				<tr class="user-description-wrap">
					<th>'.esc_html__('User Type', 'dtlms').'</th>
					<td>';
						$user_type = get_the_author_meta('user-type', $user->ID);
						$user_type = isset($user_type) ? $user_type : '';
						echo '<input class="large" type="text" placeholder="'.esc_html__('Instructor Type', 'dtlms').'" style="width:80%" id="user-type" name="user-type" value="'.$user_type.'" />
					</td>
				</tr>


				<tr class="user-profile-picture">
					<th>'.esc_html__('Social Links', 'dtlms').'</th>
					<td>

						<div id="dtlms-user-details-container">';

							$user_social_items = get_the_author_meta('user-social-items', $user->ID);
							$user_social_items = (isset($user_social_items) && is_array($user_social_items)) ? $user_social_items : array();

							$user_social_items_value = get_the_author_meta('user-social-items-value', $user->ID);
							$user_social_items_value = (isset($user_social_items_value) && is_array($user_social_items_value)) ? $user_social_items_value : array();

							$i = 0;
							foreach($user_social_items as $user_social_item) {

							    echo '<div id="dtlms-user-section-item">';

									echo '<select class="social-item-list social-item-chosen" id="user-social-items" name="user-social-items[]">';
										foreach ( $sociables as $sociable_key => $sociable_value ) :
											$s = ($sociable_key == $user_social_item) ? 'selected="selected"' : '';
											$v = ucwords ( $sociable_value );
											echo '<option value="'.$sociable_key.'" '.$s.'>'.$v.'</option>';
										endforeach;
									echo '</select>';

							        echo '<input class="large" type="text" placeholder="'.esc_html__('Social Link', 'dtlms').'" style="width:91.2%" id="user-social-items-value" name="user-social-items-value[]" value="'.$user_social_items_value[$i].'" />';

							        echo '<span class="dtlms-remove-user-tab"><span class="fas fa-times"></span></span>';
							        echo '<span class="fas fa-arrows-alt"></span>';

							    echo '</div>';

							    $i++;

							}

					echo '</div>';

					echo '<a href="#" class="dtlms-add-user-social custom-button-style">'.esc_html__('Add Social Item', 'dtlms').'</a>';

				    echo '<div id="dtlms-user-section-to-clone" class="hidden">';

						echo '<select class="social-item-list">';
							foreach ( $sociables as $key => $value ) :
								$v = ucwords ( $value );
								echo '<option value="'.$key.'">'.$v.'</option>';
							endforeach;
						echo '</select>';

				        echo '<input class="large" type="text" placeholder="'.esc_html__('Social Link', 'dtlms').'" style="width:91.2%" />';

				        echo '<span class="dtlms-remove-user-tab"><span class="fas fa-times"></span></span>';
				        echo '<span class="fas fa-arrows-alt"></span>';

				    echo '</div>';
				 echo '</td>
				</tr>
				<tr>';

				$current_user = wp_get_current_user();
				$user_id = $current_user->ID;

				//if ( in_array( 'administrator', (array) $current_user->roles ) ) {

						echo '<th>'.esc_html__('Custom Profile Picture', 'dtlms').'</th>';
							echo '<td>'.dtlms_user_profile_picture_field($user->ID).'</td>';
						echo '</tr>
						<tr>
						<tr>
						<th>'.esc_html__('Secondary Profile Picture', 'dtlms').'</th>';
							echo '<td>'.dtlms_user_secondary_profile_picture_field($user->ID).'</td>';
						echo '</tr>
						<tr>

						<th>'.esc_html__('Signature Picture', 'dtlms').'</th>';
							echo '<td>'.dtlms_user_signature_field($user->ID).'</td>';
						echo '</tr>';
						echo'<tr>';
				//}
				echo'<th>'.esc_html__('Education', 'dtlms').'</th>';
					$user_education = get_the_author_meta('user-education', $user->ID);
					$user_education = isset($user_education) ? $user_education : '';
				echo '<td>'; 
					echo '<input class="large" type="text" placeholder="'.esc_html__('Education', 'dtlms').'" style="width:80%" id="user-education" name="user-education" value="'.$user_education.'" />';
				echo '</td>';
				echo '</tr>';

				echo '<tr>';
				echo '<th>'.esc_html__('Experience', 'dtlms').'</th>';
					$user_experience = get_the_author_meta('user-experience', $user->ID);
					$user_experience = isset($user_experience) ? $user_experience : '';
				echo '<td>'; 
					echo '<input class="large" type="text" placeholder="'.esc_html__('Experience', 'dtlms').'" style="width:80%" id="user-experience" name="user-experience" value="'.$user_experience.'" />';
				echo '</td>';
				echo '</tr>
			</tbody>
		</table>';

}

add_action( 'personal_options_update', 'dtlms_save_social_links_sc' );
add_action( 'edit_user_profile_update', 'dtlms_save_social_links_sc' );
function dtlms_save_social_links_sc( $user_id )
{
	if(isset($_POST['user-specialization']) && $_POST['user-specialization'] != '') {
		update_user_meta( $user_id,'user-specialization', dtlms_recursive_sanitize_text_field($_POST['user-specialization']) );
	}
	
	if(isset($_POST['user-type']) && $_POST['user-type'] != '') {
		update_user_meta( $user_id,'user-type', dtlms_recursive_sanitize_text_field($_POST['user-type']) );
	}

	if(isset($_POST['user-tempalte-id']) && $_POST['user-tempalte-id'] != '') {
		update_user_meta( $user_id,'user-tempalte-id', dtlms_recursive_sanitize_text_field($_POST['user-tempalte-id']) );
	}

	if(isset($_POST['user-experience']) && $_POST['user-experience'] != '') {
		update_user_meta( $user_id,'user-experience', dtlms_recursive_sanitize_text_field($_POST['user-experience']) );
	}

	if(isset($_POST['user-education']) && $_POST['user-education'] != '') {
		update_user_meta( $user_id,'user-education', dtlms_recursive_sanitize_text_field($_POST['user-education']) );
	}

	if(isset($_POST['user-social-items']) && $_POST['user-social-items'] != '') {
		update_user_meta( $user_id,'user-social-items', dtlms_recursive_sanitize_text_field($_POST['user-social-items']) );
	}
	if(isset($_POST['user-social-items-value']) && $_POST['user-social-items-value'] != '') {
		update_user_meta( $user_id,'user-social-items-value', dtlms_recursive_sanitize_text_field($_POST['user-social-items-value']) );
	}
	if(isset($_POST['dtlms_user_profile_image_url']) && $_POST['dtlms_user_profile_image_url'] != '') {
		update_user_meta( $user_id,'dtlms_user_profile_image_url', dtlms_recursive_sanitize_text_field ( $_POST['dtlms_user_profile_image_url'] ) );
	} else {
		delete_user_meta( $user_id, 'dtlms_user_profile_image_url' );

	}
	if(isset($_POST['dtlms_user_secondary_profile_image_url']) && $_POST['dtlms_user_secondary_profile_image_url'] != '') {
		update_user_meta( $user_id,'dtlms_user_secondary_profile_image_url', dtlms_recursive_sanitize_text_field ( $_POST['dtlms_user_secondary_profile_image_url'] ) );
	} else {
		delete_user_meta( $user_id, 'dtlms_user_secondary_profile_image_url' );
	}
	if(isset($_POST['dtlms_user_signature_url']) && $_POST['dtlms_user_signature_url'] != '') {
		update_user_meta( $user_id,'dtlms_user_signature_url', dtlms_recursive_sanitize_text_field ( $_POST['dtlms_user_signature_url'] ) );
	} else {
		delete_user_meta( $user_id, 'dtlms_user_signature_url' );
	}
	if(isset($_POST['dtlms_student_profile_image_url']) && $_POST['dtlms_student_profile_image_url'] != '') {
		update_user_meta( $user_id,'dtlms_student_profile_image_url', dtlms_recursive_sanitize_text_field ( $_POST['dtlms_student_profile_image_url'] ) );
	} else {
		delete_user_meta( $user_id, 'dtlms_student_profile_image_url' );

	}
}

?>