<?php 


get_header('dtlms'); ?>

	<?php
	/**
	* dtlms_before_main_content hook.
	*/
	do_action( 'dtlms_author_main_content' );
	?>

		<?php
		/**
		* dtlms_before_content hook.
		*/
		do_action( 'dtlms_before_content' );
		?>

			<?php

			$author_id = get_queried_object_id();
			$user_meta = get_userdata($author_id);
			$user_roles = $user_meta->roles;
			$usermeta = get_user_meta( $author_id );
			$socialitemnames=$usermeta['user-social-items'][0];
			$socialitemnames = unserialize( $socialitemnames );
			$socialitems=$usermeta['user-social-items-value'][0];
			$socialitems = unserialize( $socialitems );
			$data = $usermeta['dtlms_user_profile_image_url'][0];
			$phone = get_user_meta( get_queried_object_id(), 'billing_phone', true );
			$address = get_user_meta( get_queried_object_id(), 'billing_address_1', true );
			$userexperience = get_user_meta( get_queried_object_id(), 'user-experience', true );
			$usereducation = get_the_author_meta('user-education', $user->ID);
			$user_email = $user_meta->user_email;
			$user_type = get_the_author_meta('user-type', $user->ID);
			$user_type = isset($user_type) ? $user_type : 'Online Coach';

			if( $data !='') {
				$data = $usermeta['dtlms_user_profile_image_url'][0];
			} else  {
				$data = DTLMS_PLUGIN_URL.'assets/images/no-image-644.jpg';
			}


			if(in_array('instructor', $user_roles)) {

				echo '<div class="dtlms-column dtlms-one-third first">';
						echo '<img src="'.esc_url($data).'"  class="dtlms-single-instructor-thumb" alt="'.esc_html__('Instructor Image', 'dtlms').'" title="'.esc_html__('Instructor Image', 'dtlms').'" />';
						echo '<div class="dtlms-column dtlms-istructor-name">';
							echo '<h2 class="dtlms-single-instructor-name">'.$user_name = ucfirst($user_meta->display_name).'</h2>' ;
							echo '<p class="dtlms-single-instructor-subitem">'.$user_type.'</p>';
						echo '</div>';
				echo '</div>';


				echo '<div class="dtlms-column dtlms-two-third dtlms-single-instructor-details">';
					echo '<div class="dtlms-single-instructor-about">';
						echo '<h2 class="dtlms-single-instructor-name">'.esc_html__('About Me', 'dtlms').'</h2>';
						echo '<p class="dtlms-single-instructor-description">'.$usermeta['description'][0].'</p>';
					echo '</div>';

					echo '<div class="dtlms-single-instructor-professional">';
						echo '<h4 class="dtlms-single-instructor-experience">'.$userexperience.'</h4>';
							$average_rating = get_post_meta($author_id, 'average-ratings', true);
							$average_rating = (isset($average_rating) && !empty($average_rating)) ? round($average_rating, 1) : 0;
						
							$comments = get_approved_comments($author_id);
							$total_comments = count($comments);
					
						echo '<div class="dtlms-author-detail-ratings-container">';
						echo '<div class="dtlms-author-detail-ratings">'.dtlms_comment_rating_display($average_rating).'</div>';
							echo '<div class="dtlms-author-detail-average-ratings">'.esc_html($average_rating).'</div>';
								echo '<div class="dtlms-author-detail-total-reviews">( '.number_format_i18n($total_comments).' )</div>';
							echo'</div>';
						echo '<p class="dtlms-single-instructor-experience-description">'.$usermeta['user-education'][0].'</p>';
					echo '</div>';

					echo '<ul class="dtlms-single-instructor-personal-details">';
						echo '<li class="dtlms-single-instructor-phone">
								<svg data-name="Group 615" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="25.047" height="23.924" viewBox="0 0 25.047 23.924">
								<defs>
								<clipPath>
									<rect data-name="Rectangle 249" width="25.047" height="23.924" fill="#191919"/>
								</clipPath>
								</defs>
								<g data-name="Group 614" clip-path="url(#clip-path)">
								<path data-name="Path 7694" d="M17.37,18.173c-1.155.559-5.974-2.23-7.667-3.923a15.131,15.131,0,0,1-1.324-1.515q-.4-.524-.744-1.069a27.374,27.374,0,0,1-1.37-2.813c-.014-.04-.027-.08-.041-.121-.133-.537.372-1.165.956-1.685.931-.582,1.886-1.28,1.886-1.695a5.049,5.049,0,0,0-.038-.534c-.04-.2-1.823-3.794-1.823-3.794A5.41,5.41,0,0,0,6.9.381v0A1.573,1.573,0,0,0,6.624.067,10.23,10.23,0,0,0,3.765.235a9.73,9.73,0,0,0-2.448,1.4l-.124.1q-.07.059-.137.119c-2.363,2.184-.044,8.259.106,8.644a25.263,25.263,0,0,0,2.3,4.4,21.029,21.029,0,0,0,6.758,6.505,21.594,21.594,0,0,0,4.4,2.009A8.439,8.439,0,0,0,22.6,22.3s2.51-3.113,2.443-4.588a1.493,1.493,0,0,0-.732-1.02,7.555,7.555,0,0,0-1.594-.833c-.467-.191-.942-.361-1.422-.517q-.36-.117-.723-.223a1.431,1.431,0,0,0-.659-.137,1.984,1.984,0,0,0-.547.2,1.323,1.323,0,0,0-.472.588q-.19.341-.387.679a16.076,16.076,0,0,1-1.01,1.56q-.064.084-.13.167" transform="translate(0 0.001)" fill="#191919"/>
								</g>
							</svg>
					  		<a  href="tel:'.$phone.'">'.$phone.'</a></li>';
						echo '<li class="dtlms-single-instructor-email">
							<svg data-name="Vector Smart Object" xmlns="http://www.w3.org/2000/svg" width="25.047" height="16.967" viewBox="0 0 25.047 16.967">
							<g data-name="Group 601" transform="translate(0 0)">
							<path data-name="Path 7490" d="M37.836,50.96a3.853,3.853,0,0,0-2.646-1.046H17.824a3.853,3.853,0,0,0-2.646,1.046L26.159,61.233a.512.512,0,0,0,.7,0Z" transform="translate(-13.99 -49.914)" fill="#191919"/>
								<g id="Group_600" data-name="Group 600" transform="translate(0 1.817)">
									<path data-name="Path 7491" d="M42.127,65.586a3.677,3.677,0,0,0,.609-2.024V54.094a3.676,3.676,0,0,0-.552-1.931L34.442,59.4Z" transform="translate(-17.689 -52.163)" fill="#191919"/>
									<path data-name="Path 7492" d="M17.842,69.2H35.208a3.853,3.853,0,0,0,2.571-.971l-7.768-6.245-2.887,2.7a.882.882,0,0,1-1.2,0l-2.886-2.7L15.27,68.227A3.853,3.853,0,0,0,17.842,69.2Z" transform="translate(-14.007 -54.049)" fill="#191919"/>
									<path data-name="Path 7493" d="M22.01,59.4l-7.747-7.241a3.679,3.679,0,0,0-.556,1.931v9.468a3.681,3.681,0,0,0,.613,2.024Z" transform="translate(-13.707 -52.163)" fill="#191919"/>
								</g>
							</g>
						</svg>
					  	<a href="mailto:'.$user_email.'">'.$user_email.'</a></li>';
						echo '<li class="dtlms-single-instructor-address">
								<svg xmlns="http://www.w3.org/2000/svg" width="22" height="28" viewBox="0 0 22 28">
								<g id="Vector_Smart_Object" data-name="Vector Smart Object" transform="translate(-17.714 -11.693)">
								<path id="Path_7489" data-name="Path 7489" d="M28.748,11.7c-7.434-.266-12.156,8.115-10.8,13.617.688,2.8,2.8,5.178,4.748,7.46,1.79,2.093,3.61,4.249,5.208,6.466a1.091,1.091,0,0,0,1.76.008c1.267-1.7,3.58-4.77,5.037-6.474,1.952-2.282,4.1-4.663,4.783-7.46C40.833,19.814,36.182,11.434,28.748,11.7Zm-.034,15.5a4.485,4.485,0,1,1,4.472-4.484A4.478,4.478,0,0,1,28.714,27.2Z" fill="#191919"/>
								</g>
							</svg>
					  	<span>'.$address.'</span>
						</li>';
					echo '</ul>';

					echo '<div class="dtlms-single-instructor-intouch-button">';
						echo '<a href="" class="dtlms-single-instructor-intouch-button-item button">'.esc_html__('Get In Touch', 'dtlms').'</a>';
					echo '</div>';
				echo '</div>';


				echo '<div class="dtlms-column one-column first dtlms-single-instructor-education">';
					if (class_exists("\\Elementor\\Plugin")) {

						$user_template_id = get_the_author_meta('user-tempalte-id', $user->ID);
						$user_template_id = isset($user_template_id) ? $user_template_id : '';
						$post_ID = $user_template_id;
						$pluginElementor = \Elementor\Plugin::instance();
						$contentElementor = $pluginElementor->frontend->get_builder_content($post_ID);
					}
					
					echo $contentElementor;

				echo '</div>';

			}

		/**
		* dtlms_after_content hook.
		*/
		 do_action( 'dtlms_after_content' );
		

	/**
	* dtlms_after_main_content hook.
	*/
	do_action( 'dtlms_after_main_content' );

get_footer('dtlms'); ?>