<?php

namespace OneKorseElementor\Widgets;
use OneKorseElementor\Widgets\OneKorse_Shop_Widget_Product_Summary;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;


class OneKorse_Shop_Widget_Product_Summary_Extend extends OneKorse_Shop_Widget_Product_Summary {

	function dynamic_register_controls() {

		$this->start_controls_section( 'product_summary_extend_section', array(
			'label' => esc_html__( 'Social Options', 'onekorse-pro' ),
		) );

			$this->add_control( 'share_follow_type', array(
				'label'   => esc_html__( 'Share / Follow Type', 'onekorse-pro' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'share',
				'options' => array(
					''       => esc_html__('None', 'onekorse-pro'),
					'share'  => esc_html__('Share', 'onekorse-pro'),
					'follow' => esc_html__('Follow', 'onekorse-pro'),
				),
				'description' => esc_html__( 'Choose between Share / Follow you would like to use.', 'onekorse-pro' ),
			) );

			$this->add_control( 'social_icon_style', array(
				'label'   => esc_html__( 'Social Icon Style', 'onekorse-pro' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					'simple'        => esc_html__( 'Simple', 'onekorse-pro' ),
					'bgfill'        => esc_html__( 'BG Fill', 'onekorse-pro' ),
					'brdrfill'      => esc_html__( 'Border Fill', 'onekorse-pro' ),
					'skin-bgfill'   => esc_html__( 'Skin BG Fill', 'onekorse-pro' ),
					'skin-brdrfill' => esc_html__( 'Skin Border Fill', 'onekorse-pro' ),
				),
				'description' => esc_html__( 'This option is applicable for all buttons used in product summary.', 'onekorse-pro' ),
				'condition'   => array( 'share_follow_type' => array ('share', 'follow') )
			) );

			$this->add_control( 'social_icon_radius', array(
				'label'   => esc_html__( 'Social Icon Radius', 'onekorse-pro' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					'square'  => esc_html__( 'Square', 'onekorse-pro' ),
					'rounded' => esc_html__( 'Rounded', 'onekorse-pro' ),
					'circle'  => esc_html__( 'Circle', 'onekorse-pro' ),
				),
				'condition'   => array(
					'social_icon_style' => array ('bgfill', 'brdrfill', 'skin-bgfill', 'skin-brdrfill'),
					'share_follow_type' => array ('share', 'follow')
				),
			) );

			$this->add_control( 'social_icon_inline_alignment', array(
				'label'        => esc_html__( 'Social Icon Inline Alignment', 'onekorse-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'yes', 'onekorse-pro' ),
				'label_off'    => esc_html__( 'no', 'onekorse-pro' ),
				'default'      => '',
				'return_value' => 'true',
				'description'  => esc_html__( 'This option is applicable for all buttons used in product summary.', 'onekorse-pro' ),
				'condition'   => array( 'share_follow_type' => array ('share', 'follow') )
			) );

		$this->end_controls_section();

	}

}