<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'OneKorseProCustomizerBlogPost' ) ) {
    class OneKorseProCustomizerBlogPost {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {
            add_filter( 'onekorse_pro_customizer_default', array( $this, 'default' ) );
			add_action( 'customize_register', array( $this, 'register' ), 20 );
        }

        function default( $option ) {

            $post_defaults = array();
            if( function_exists('onekorse_single_post_params_default') ) {
                $post_defaults = onekorse_single_post_params_default();
            }

            $option['enable_title'] 		  = $post_defaults['enable_title'];
            $option['enable_image_lightbox']  = $post_defaults['enable_image_lightbox'];
			$option['enable_disqus_comments'] = $post_defaults['enable_disqus_comments'];
			$option['post_disqus_shortname']  = $post_defaults['post_disqus_shortname'];
			$option['post_dynamic_elements']  = $post_defaults['post_dynamic_elements'];
            $option['post_commentlist_style'] = $post_defaults['post_commentlist_style'];

            $post_misc_defaults = array();
            if( function_exists('onekorse_single_post_misc_default') ) {
                $post_misc_defaults = onekorse_single_post_misc_default();
            }

            $option['enable_related_article'] = $post_misc_defaults['enable_related_article'];
			$option['rposts_title']    		  = $post_misc_defaults['rposts_title'];
			$option['rposts_column']   		  = $post_misc_defaults['rposts_column'];
			$option['rposts_count']    		  = $post_misc_defaults['rposts_count'];
			$option['rposts_excerpt']  		  = $post_misc_defaults['rposts_excerpt'];
			$option['rposts_excerpt_length']  = $post_misc_defaults['rposts_excerpt_length'];
			$option['rposts_carousel']  	  = $post_misc_defaults['rposts_carousel'];
			$option['rposts_carousel_nav']    = $post_misc_defaults['rposts_carousel_nav'];

            return $option;
        }

        function register( $wp_customize ) {

			/**
			 * Option : Post Title
			 */
			$wp_customize->add_setting(
				ONEKORSE_CUSTOMISER_VAL . '[enable_title]', array(
					'type' => 'option',
				)
			);

			$wp_customize->add_control(
				new OneKorse_Customize_Control_Switch(
					$wp_customize, ONEKORSE_CUSTOMISER_VAL . '[enable_title]', array(
						'type'    => 'wdt-switch',
						'label'   => esc_html__( 'Enable Title', 'onekorse-pro'),
						'description' => esc_html__('YES! to enable the title of single post.', 'onekorse-pro'),
						'section' => 'site-blog-post-section',
						'choices' => array(
							'on'  => esc_attr__( 'Yes', 'onekorse-pro' ),
							'off' => esc_attr__( 'No', 'onekorse-pro' )
						)
					)
				)
			);

			/**
			 * Option : Post Elements
			 */
			$wp_customize->add_setting(
				ONEKORSE_CUSTOMISER_VAL . '[post_dynamic_elements]', array(
					'type' => 'option',
				)
			);

			$wp_customize->add_control(
				new OneKorse_Customize_Control_Sortable(
					$wp_customize, ONEKORSE_CUSTOMISER_VAL . '[post_dynamic_elements]', array(
						'type' => 'wdt-sortable',
						'label' => esc_html__( 'Post Elements Positioning', 'onekorse-pro'),
						'section' => 'site-blog-post-section',
						'choices' => apply_filters( 'onekorse_blog_post_dynamic_elements', array(
							'author'		=> esc_html__('Author', 'onekorse-pro'),
							'author_bio' 	=> esc_html__('Author Bio', 'onekorse-pro'),
							'category'    	=> esc_html__('Categories', 'onekorse-pro'),
							'comment' 		=> esc_html__('Comments', 'onekorse-pro'),
							'comment_box' 	=> esc_html__('Comment Box', 'onekorse-pro'),
							'content'    	=> esc_html__('Content', 'onekorse-pro'),
							'date'     		=> esc_html__('Date', 'onekorse-pro'),
							'image'			=> esc_html__('Feature Image', 'onekorse-pro'),
							'navigation'    => esc_html__('Navigation', 'onekorse-pro'),
							'tag'  			=> esc_html__('Tags', 'onekorse-pro'),
							'title'      	=> esc_html__('Title', 'onekorse-pro'),
							'likes_views'   => esc_html__('Likes & Views', 'onekorse-pro'),
							'related_posts' => esc_html__('Related Posts', 'onekorse-pro'),
							'social'  		=> esc_html__('Social Share', 'onekorse-pro'),
						)
					),
				)
			));

			/**
			 * Option : Image Lightbox
			 */
			$wp_customize->add_setting(
				ONEKORSE_CUSTOMISER_VAL . '[enable_image_lightbox]', array(
					'type' => 'option',
				)
			);

			$wp_customize->add_control(
				new OneKorse_Customize_Control_Switch(
					$wp_customize, ONEKORSE_CUSTOMISER_VAL . '[enable_image_lightbox]', array(
						'type'    => 'wdt-switch',
						'label'   => esc_html__( 'Feature Image Lightbox', 'onekorse-pro'),
						'description' => esc_html__('YES! to enable lightbox for feature image. Will not work in "Overlay" style.', 'onekorse-pro'),
						'section' => 'site-blog-post-section',
						'choices' => array(
							'on'  => esc_attr__( 'Yes', 'onekorse-pro' ),
							'off' => esc_attr__( 'No', 'onekorse-pro' )
						)
					)
				)
			);

			/**
			 * Option : Related Article
			 */
			$wp_customize->add_setting(
				ONEKORSE_CUSTOMISER_VAL . '[enable_related_article]', array(
					'type' => 'option',
				)
			);

			$wp_customize->add_control(
				new OneKorse_Customize_Control_Switch(
					$wp_customize, ONEKORSE_CUSTOMISER_VAL . '[enable_related_article]', array(
						'type'    => 'wdt-switch',
						'label'   => esc_html__( 'Enable Related Article', 'onekorse-pro'),
						'description' => esc_html__('YES! to enable related article at right hand side of post.', 'onekorse-pro'),
						'section' => 'site-blog-post-section',
						'choices' => array(
							'on'  => esc_attr__( 'Yes', 'onekorse-pro' ),
							'off' => esc_attr__( 'No', 'onekorse-pro' )
						)
					)
				)
			);

			/**
			 * Option : Disqus Comments
			 */
			$wp_customize->add_setting(
				ONEKORSE_CUSTOMISER_VAL . '[enable_disqus_comments]', array(
					'type' => 'option',
				)
			);

			$wp_customize->add_control(
				new OneKorse_Customize_Control_Switch(
					$wp_customize, ONEKORSE_CUSTOMISER_VAL . '[enable_disqus_comments]', array(
						'type'    => 'wdt-switch',
						'label'   => esc_html__( 'Enable Disqus Comments', 'onekorse-pro'),
						'description' => esc_html__('YES! to enable disqus platform comments module.', 'onekorse-pro'),
						'section' => 'site-blog-post-section',
						'choices' => array(
							'on'  => esc_attr__( 'Yes', 'onekorse-pro' ),
							'off' => esc_attr__( 'No', 'onekorse-pro' )
						)
					)
				)
			);

			/**
			 * Option : Disqus Short Name
			 */
			$wp_customize->add_setting(
				ONEKORSE_CUSTOMISER_VAL . '[post_disqus_shortname]', array(
					'type' => 'option',
				)
			);

			$wp_customize->add_control(
				new OneKorse_Customize_Control(
					$wp_customize, ONEKORSE_CUSTOMISER_VAL . '[post_disqus_shortname]', array(
						'type'    	  => 'textarea',
						'section'     => 'site-blog-post-section',
						'label'       => esc_html__( 'Shortname', 'onekorse-pro' ),
						'input_attrs' => array(
							'placeholder' => 'disqus',
						),
						'dependency' => array( 'enable_disqus_comments', '==', 'true' ),
					)
				)
			);

			/**
			 * Option : Disqus Description
			 */
			$wp_customize->add_setting(
				ONEKORSE_CUSTOMISER_VAL . '[post_disqus_description]', array(
					'type' => 'option',
				)
			);

			$wp_customize->add_control(
				new OneKorse_Customize_Control_Description(
					$wp_customize, ONEKORSE_CUSTOMISER_VAL . '[post_disqus_description]', array(
						'type'    	  => 'wdt-description',
						'section'     => 'site-blog-post-section',
						'description' => esc_html__('Your site\'s unique identifier', 'onekorse-pro').' '.'<a href="'.esc_url('https://help.disqus.com/customer/portal/articles/466208').'" target="_blank">'.esc_html__('What is this?', 'onekorse-pro').'</a>',
						'dependency' => array( 'enable_disqus_comments', '==', 'true' ),
					)
				)
			);

			/**
			 * Option : Comment List Style
			 */
			$wp_customize->add_setting(
				ONEKORSE_CUSTOMISER_VAL . '[post_commentlist_style]', array(
					'type' => 'option',
				)
			);

			$wp_customize->add_control( new OneKorse_Customize_Control(
				$wp_customize, ONEKORSE_CUSTOMISER_VAL . '[post_commentlist_style]', array(
					'type'    => 'select',
					'section' => 'site-blog-post-section',
					'label'   => esc_html__( 'Comments List Style', 'onekorse-pro' ),
					'choices' => array(
						'rounded' 	=> esc_html__('Rounded', 'onekorse-pro'),
						'square'   	=> esc_html__('Square', 'onekorse-pro'),
					),
					'description' => esc_html__('Choose comments list style to display single post.', 'onekorse-pro'),
					'dependency' => array( 'enable_disqus_comments', '!=', 'true' ),
				)
			));

			/**
			 * Option : Post Related Title
			 */
			$wp_customize->add_setting(
				ONEKORSE_CUSTOMISER_VAL . '[rposts_title]', array(
					'type' => 'option',
				)
			);

			$wp_customize->add_control(
				new OneKorse_Customize_Control(
					$wp_customize, ONEKORSE_CUSTOMISER_VAL . '[rposts_title]', array(
						'type'    	  => 'text',
						'section'     => 'site-blog-post-section',
						'label'       => esc_html__( 'Related Posts Section Title', 'onekorse-pro' ),
						'description' => esc_html__('Put the related posts section title here', 'onekorse-pro'),
						'input_attrs' => array(
							'value'	=> esc_html__('Related Posts', 'onekorse-pro'),
						)
					)
				)
			);

			/**
			 * Option : Related Columns
			 */
			$wp_customize->add_setting(
				ONEKORSE_CUSTOMISER_VAL . '[rposts_column]', array(
					'type' => 'option',
				)
			);

			$wp_customize->add_control( new OneKorse_Customize_Control_Radio_Image(
				$wp_customize, ONEKORSE_CUSTOMISER_VAL . '[rposts_column]', array(
					'type' => 'wdt-radio-image',
					'label' => esc_html__( 'Columns', 'onekorse-pro'),
					'section' => 'site-blog-post-section',
					'choices' => apply_filters( 'onekorse_blog_post_related_columns', array(
						'one-column' => array(
							'label' => esc_html__( 'One Column', 'onekorse-pro' ),
							'path' => ONEKORSE_PRO_DIR_URL . 'modules/post/customizer/images/one-column.png'
						),
						'one-half-column' => array(
							'label' => esc_html__( 'One Half Column', 'onekorse-pro' ),
							'path' => ONEKORSE_PRO_DIR_URL . 'modules/post/customizer/images/one-half-column.png'
						),
						'one-third-column' => array(
							'label' => esc_html__( 'One Third Column', 'onekorse-pro' ),
							'path' => ONEKORSE_PRO_DIR_URL . 'modules/post/customizer/images/one-third-column.png'
						),
					)),
				)
			));

			/**
			 * Option : Related Count
			 */
			$wp_customize->add_setting(
				ONEKORSE_CUSTOMISER_VAL . '[rposts_count]', array(
					'type' => 'option',
				)
			);

			$wp_customize->add_control(
				new OneKorse_Customize_Control(
					$wp_customize, ONEKORSE_CUSTOMISER_VAL . '[rposts_count]', array(
						'type'    	  => 'text',
						'section'     => 'site-blog-post-section',
						'label'       => esc_html__( 'No.of Posts to Show', 'onekorse-pro' ),
						'description' => esc_html__('Put the no.of related posts to show', 'onekorse-pro'),
						'input_attrs' => array(
							'value'	=> 3,
						),
					)
				)
			);

			/**
			 * Option : Enable Excerpt
			 */
			$wp_customize->add_setting(
				ONEKORSE_CUSTOMISER_VAL . '[rposts_excerpt]', array(
					'type' => 'option',
				)
			);

			$wp_customize->add_control(
				new OneKorse_Customize_Control_Switch(
					$wp_customize, ONEKORSE_CUSTOMISER_VAL . '[rposts_excerpt]', array(
						'type'    => 'wdt-switch',
						'label'   => esc_html__( 'Enable Excerpt Text', 'onekorse-pro'),
						'section' => 'site-blog-post-section',
						'choices' => array(
							'on'  => esc_attr__( 'Yes', 'onekorse-pro' ),
							'off' => esc_attr__( 'No', 'onekorse-pro' )
						)
					)
				)
			);

			/**
			 * Option : Excerpt Text
			 */
			$wp_customize->add_setting(
				ONEKORSE_CUSTOMISER_VAL . '[rposts_excerpt_length]', array(
					'type' => 'option',
				)
			);

			$wp_customize->add_control(
				new OneKorse_Customize_Control(
					$wp_customize, ONEKORSE_CUSTOMISER_VAL . '[rposts_excerpt_length]', array(
						'type'    	  => 'text',
						'section'     => 'site-blog-post-section',
						'label'       => esc_html__( 'Excerpt Length', 'onekorse-pro' ),
						'description' => esc_html__('Put Excerpt Length', 'onekorse-pro'),
						'input_attrs' => array(
							'value'	=> 25,
						),
						'dependency' => array( 'rposts_excerpt', '==', 'true' ),
					)
				)
			);

			/**
			 * Option : Related Carousel
			 */
			$wp_customize->add_setting(
				ONEKORSE_CUSTOMISER_VAL . '[rposts_carousel]', array(
					'type' => 'option',
				)
			);

			$wp_customize->add_control(
				new OneKorse_Customize_Control_Switch(
					$wp_customize, ONEKORSE_CUSTOMISER_VAL . '[rposts_carousel]', array(
						'type'    => 'wdt-switch',
						'label'   => esc_html__( 'Enable Carousel', 'onekorse-pro'),
						'description' => esc_html__('YES! to enable carousel related posts', 'onekorse-pro'),
						'section' => 'site-blog-post-section',
						'choices' => array(
							'on'  => esc_attr__( 'Yes', 'onekorse-pro' ),
							'off' => esc_attr__( 'No', 'onekorse-pro' )
						)
					)
				)
			);

			/**
			 * Option : Related Carousel Nav
			 */
			$wp_customize->add_setting(
				ONEKORSE_CUSTOMISER_VAL . '[rposts_carousel_nav]', array(
					'type' => 'option',
				)
			);

			$wp_customize->add_control( new OneKorse_Customize_Control(
				$wp_customize, ONEKORSE_CUSTOMISER_VAL . '[rposts_carousel_nav]', array(
					'type'    => 'select',
					'section' => 'site-blog-post-section',
					'label'   => esc_html__( 'Navigation Style', 'onekorse-pro' ),
					'choices' => array(
						'' 			 => esc_html__('None', 'onekorse-pro'),
						'navigation' => esc_html__('Navigations', 'onekorse-pro'),
						'pager'   	 => esc_html__('Pager', 'onekorse-pro'),
					),
					'description' => esc_html__('Choose navigation style to display related post carousel.', 'onekorse-pro'),
					'dependency' => array( 'rposts_carousel', '==', 'true' ),
				)
			));

        }
    }
}

OneKorseProCustomizerBlogPost::instance();