<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if (! class_exists ( 'OneKorsePlusFooterPostType' ) ) {

	class OneKorsePlusFooterPostType {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

		function __construct() {

			add_action ( 'init', array( $this, 'onekorse_register_cpt' ) );
			add_filter ( 'template_include', array ( $this, 'onekorse_template_include' ) );
		}

		function onekorse_register_cpt() {

			$labels = array (
				'name'				 => __( 'Footers', 'onekorse-plus' ),
				'singular_name'		 => __( 'Footer', 'onekorse-plus' ),
				'menu_name'			 => __( 'Footers', 'onekorse-plus' ),
				'add_new'			 => __( 'Add Footer', 'onekorse-plus' ),
				'add_new_item'		 => __( 'Add New Footer', 'onekorse-plus' ),
				'edit'				 => __( 'Edit Footer', 'onekorse-plus' ),
				'edit_item'			 => __( 'Edit Footer', 'onekorse-plus' ),
				'new_item'			 => __( 'New Footer', 'onekorse-plus' ),
				'view'				 => __( 'View Footer', 'onekorse-plus' ),
				'view_item' 		 => __( 'View Footer', 'onekorse-plus' ),
				'search_items' 		 => __( 'Search Footers', 'onekorse-plus' ),
				'not_found' 		 => __( 'No Footers found', 'onekorse-plus' ),
				'not_found_in_trash' => __( 'No Footers found in Trash', 'onekorse-plus' ),
			);

			$args = array (
				'labels' 				=> $labels,
				'public' 				=> true,
				'exclude_from_search'	=> true,
				'show_in_nav_menus' 	=> false,
				'show_in_rest' 			=> true,
				'menu_position'			=> 26,
				'menu_icon' 			=> 'dashicons-editor-insertmore',
				'hierarchical' 			=> false,
				'supports' 				=> array ( 'title', 'editor', 'revisions' ),
			);

			register_post_type ( 'wdt_footers', $args );
		}

		function onekorse_template_include($template) {
			if ( is_singular( 'wdt_footers' ) ) {
				if ( ! file_exists ( get_stylesheet_directory () . '/single-wdt_footers.php' ) ) {
					$template = ONEKORSE_PLUS_DIR_PATH . 'post-types/templates/single-wdt_footers.php';
				}
			}

			return $template;
		}
	}
}

OneKorsePlusFooterPostType::instance();