<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'OneKorsePlusCustomizerSiteTagline' ) ) {
    class OneKorsePlusCustomizerSiteTagline {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {
            add_action( 'customize_register', array( $this, 'register' ), 15 );
        }

        function register( $wp_customize ) {

            $wp_customize->add_section(
                new OneKorse_Customize_Section(
                    $wp_customize,
                    'site-tagline-section',
                    array(
                        'title'    => esc_html__('Site Tagline', 'onekorse-plus'),
                        'panel'    => 'site-identity-main-panel',
                        'priority' => 15,
                    )
                )
            );

            $wp_customize->get_control('blogdescription')->section = 'site-tagline-section';
            $wp_customize->get_control('blogdescription')->priority = 5;

            if ( ! defined( 'ONEKORSE_PRO_VERSION' ) ) {
                $wp_customize->add_control(
                    new OneKorse_Customize_Control_Separator(
                        $wp_customize, ONEKORSE_CUSTOMISER_VAL . '[onekorse-plus-site-tagline-separator]',
                        array(
                            'type'        => 'wdt-separator',
                            'section'     => 'site-tagline-section',
                            'settings'    => array(),
                            'caption'     => ONEKORSE_PLUS_REQ_CAPTION,
                            'description' => ONEKORSE_PLUS_REQ_DESC,
                        )
                    )
                );
            }

        }

    }
}

OneKorsePlusCustomizerSiteTagline::instance();