<?php

if(!function_exists('wdt_generate_skin_colors')) {

	function wdt_generate_skin_colors() {

		$output = '';

		$skin_settings = get_option('wdt-skin-settings');

		$primary_color = ( isset($skin_settings['primary-color']) && '' !=  $skin_settings['primary-color'] ) ? $skin_settings['primary-color'] : '#1e306e';
		$primary_color_rgba = wdt_hex2rgb( $primary_color );
		$primary_color_rgba = implode(',', $primary_color_rgba);

		$secondary_color = ( isset($skin_settings['secondary-color']) && '' !=  $skin_settings['secondary-color'] ) ? $skin_settings['secondary-color'] : '#2fa5fb';
		$secondary_color_rgba = wdt_hex2rgb( $secondary_color );
		$secondary_color_rgba = implode(',', $secondary_color_rgba);

		$tertiary_color = ( isset($skin_settings['tertiary-color']) && '' !=  $skin_settings['tertiary-color'] ) ? $skin_settings['tertiary-color'] : '#d2edf8';
		$tertiary_color_rgba = wdt_hex2rgb( $tertiary_color );
		$tertiary_color_rgba = implode(',', $tertiary_color_rgba);

		$primary_alternate_color = ( isset($skin_settings['primary-alternate-color']) && '' !=  $skin_settings['primary-alternate-color'] ) ? $skin_settings['primary-alternate-color'] : '';
		$primary_alternate_color_rgba = wdt_hex2rgb( $primary_alternate_color );
		$primary_alternate_color_rgba = implode(',', $primary_alternate_color_rgba);

		$secondary_alternate_color = ( isset($skin_settings['secondary-alternate-color']) && '' !=  $skin_settings['secondary-alternate-color'] ) ? $skin_settings['secondary-alternate-color'] : '';
		$secondary_alternate_color_rgba = wdt_hex2rgb( $secondary_alternate_color );
		$secondary_alternate_color_rgba = implode(',', $secondary_alternate_color_rgba);

		$tertiary_alternate_color = ( isset($skin_settings['tertiary-alternate-color']) && '' !=  $skin_settings['tertiary-alternate-color'] ) ? $skin_settings['tertiary-alternate-color'] : '';
		$tertiary_alternate_color_rgba = wdt_hex2rgb( $tertiary_alternate_color );
		$tertiary_alternate_color_rgba = implode(',', $tertiary_alternate_color_rgba);


		// Primary
		$output .= '.wdt-dashbord-container .wdt-dashbord-section-holder .wdt-dashbord-section-title,	.wdt-dashbord-section-holder-content .ui-sortable .wdt-social-item-section div[class*="section-options"] span:hover, .wdt-add-listing .wdt-dashbord-section-holder-content .wdt-dashboard-option-item div[class*="wdt-dashboard-option-item"] input[type="checkbox"]:checked ~ label:before, .wdt-my-ads-container .wdt-dashbord-section-holder-content .wdt-dashbord-ads-addnew-wrapper .wdt-dashbord-ad-details input[type="checkbox"]:checked ~ label:before, .wdt-dashboard-addincharge-form .wdt-dashbord-section-holder-content .wdt-dashboard-option-item input[type="checkbox"]:checked ~ label:before, .wdt-dashbord-reviews-listing-wrapper .wdt-dashbord-reviews-listing .wdt-ratings-holder span, .wdt-listings-item-wrapper.type1 .wdt-listings-item-bottom-section-content .custom-button-style.wdt-listing-view-details, .wdt-listings-item-wrapper.type2 .wdt-listings-item-bottom-section-content > div.wdt-listings-item-bottom-pricing-holder .custom-button-style, .wdt-packages-item-wrapper .wdt-item-pricing-details ins, .wdt-packages-item-wrapper.type1 .wdt-packagelist-view-details-button span, .wdt-packages-item-wrapper.type1 .wdt-item-status-details .wdt-proceed-button .custom-button-style span, .wdt-packages-item-wrapper.type2 .wdt-packagelist-view-details .custom-button-style span, .wdt-packages-item-wrapper.type2 .wdt-packagelist-view-details .custom-button-style:hover, .wdt-packages-item-wrapper.type2 .wdt-item-status-details .custom-button-style, .wdt-packages-item-wrapper.type2 .wdt-item-status-details .added_to_cart, .wdt-packages-item-wrapper.type3 .wdt-item-status-details .custom-button-style, .wdt-packages-item-wrapper.type3 .wdt-item-status-details .added_to_cart, .wdt-packages-item-wrapper.type3 .wdt-packagelist-view-details .custom-button-style, ul.wdt-dashboard-menus li a, .wdt-packages-item-wrapper.type3 .wdt-item-status-details .wdt-purchased, .wdt-listings-item-wrapper.type3 .wdt-listings-item-bottom-section a.custom-button-style, .wdt-listings-item-wrapper.type4 .wdt-listings-item-bottom-section>div.wdt-listings-item-bottom-pricing-holder .custom-button-style:before, .wdt-listings-item-wrapper.type5 .wdt-listings-item-bottom-section a.custom-button-style, .wdt-listings-item-wrapper.type4 .wdt-listings-item-top-section .wdt-listings-item-top-section-content > div a, .wdt-listings-item-wrapper.type4 .wdt-listings-item-top-section .wdt-listings-item-top-section-content > div.wdt-listings-utils-item-holder .wdt-listings-utils-item > *, .wdt-listing-taxonomy-item .wdt-listing-taxonomy-meta-data h3 a, wdt-sf-fields-holder input[type="checkbox"].wdt-sf-field:checked ~ label:before, .wdt-sf-location-field-holder .wdt-sf-location-field-inner-holder .wdt-detect-location, .wdt-sf-fields-holder input[type="checkbox"].wdt-sf-field:checked ~ label::before, .wdt-sf-fields-holder .ui-widget.ui-widget-content .wdt-sf-radius-slider-handle, .wdt-sf-features-field-holder > div > div[class*="-handle"], .wdt-custom-login, .wdt-custom-login li a, .wdt-swiper-arrow-pagination a:hover, .wdt-sf-others-field-holder div.wdt-sf-others-list, .wdt-marker-addition-info.wdt-marker-addition-info-totalviews, .wdt-marker-addition-info.wdt-marker-addition-info-averageratings, .wdt-marker-addition-info.wdt-marker-addition-info-startdate, .wdt-marker-addition-info.wdt-marker-addition-info-distance, .wdt-listing-taxonomy-item.type2 .wdt-listing-taxonomy-icon-image > span, .wdt-listing-taxonomy-item .wdt-listing-taxonomy-starting-price-html ins > span, .wdt-listings-item-wrapper:hover .wdt-listings-item-top-section .wdt-listings-item-ad-section, .wdt-listings-item-wrapper:hover .wdt-listings-item-top-section .wdt-listings-featured-item-container, .wdt-listings-item-wrapper.type2 .wdt-listings-item-top-section .wdt-listings-featured-item-container a:after, .wdt-listings-item-wrapper.type2:hover .wdt-listings-item-top-section .wdt-listings-featured-item-container:before, .wdt-listings-item-wrapper.type7 .wdt-listings-item-top-section .wdt-listings-item-ad-section, .wdt-listings-item-wrapper.type7 .wdt-listings-item-top-section .wdt-listings-featured-item-container, .wdt-listings-item-wrapper.type5 .wdt-listings-item-top-section .wdt-listings-featured-item-container:before, .wdt-listings-item-wrapper.type5:hover .wdt-listings-item-top-section .wdt-listings-featured-item-container:after, .wdt-listings-item-wrapper.type3 .wdt-listings-item-top-section div.wdt-listings-item-ad-section, .wdt-listings-item-wrapper.type3 .wdt-listings-item-top-section div.wdt-listings-featured-item-container a, .wdt-listings-item-wrapper.type3:hover .wdt-listings-item-top-section div.wdt-listings-item-ad-section:before, .wdt-listings-item-wrapper.type1:not(.has-post-thumbnail) .wdt-listings-item-top-section .wdt-listings-item-top-section-content .wdt-listings-utils-item-holder > div a, .wdt-listings-item-wrapper.type1:not(.has-post-thumbnail) .wdt-listings-item-top-section .wdt-listings-item-top-section-content .wdt-listings-utils-item-holder > div div, .wdt-dashbord-section-holder-content ul.wdt-dashbord-inbox-listing-messages-wrapper li:hover, .wdt-dashbord-section-holder-content ul.wdt-dashbord-inbox-listing-messages-wrapper li.active, .wdt-listings-comment-list-holder .commentlist li.comment .comment-body .reply a.comment-reply-link, .wdt-listings-countdown-timer-container.type2 .wdt-listings-countdown-timer-holder .wdt-listings-countdown-timer-notice span, .wdt-listings-item-wrapper ul.wdt-listings-contactdetails-list li span, .single-wdt_packages .wdt-item-pricing-details ins, .single-wdt_packages .wdt-item-pricing-details span.amount, .single-wdt_packages .wdt-packagelist-features li:before, .wdt-listings-item-wrapper.type2:hover .wdt-listings-item-top-section .wdt-listings-featured-item-container a:before, .wdt-listings-item-wrapper.type5:hover .wdt-listings-item-top-section .wdt-listings-featured-item-container a:after, .wdt-listings-item-wrapper.type8:hover .wdt-listings-item-top-section div.wdt-listings-featured-item-container a, .wdt-listing-taxonomy-item.type6 .wdt-category-total-items a:hover, .wdt-comment-form-fields-holder input#wdt_media+label:before, .wdt-listings-item-wrapper.type5 .wdt-listings-item-top-section .wdt-listings-featured-item-container a, .wdt-swiper-arrow-pagination a:before, .wdt-packages-item-wrapper .wdt-packagelist-details > h5 a, .wdt-listings-item-wrapper .wdt-listings-item-bottom-section-content .wdt-listings-item-title a, .wdt-listings-item-wrapper.type7 .wdt-listings-item-bottom-section .wdt-listings-item-title a, .wdt-user-list-item .wdt-user-item-meta-data h4 a, .wdt-user-list-item.type1 .wdt-user-sociallinks-list li a, .wdt-user-list-item.type2 .wdt-user-contactdetails-list li a, .wdt-user-list-item.type3 .wdt-user-contactdetails-list li span, .wdt-user-list-item.type2 .wdt-user-contactdetails-list li span, .wdt-listings-item-wrapper.type3 .wdt-listings-taxonomy-container li a, .wdt-listings-taxonomy-container.type3 li a, .wdt-listings-item-wrapper .wdt-listings-excerpt span, .wdt-listings-item-wrapper.type7 .wdt-listings-item-bottom-section-content .wdt-listings-item-bottom-left-content div[class*="wdt-listings-"] label[class*="wdt-listings-"], .wdt-comment-form-fields-holder input#wdt_media + label, p.tpl-forget-pwd a, .wdt-listings-item-wrapper.type5 .wdt-listings-item-bottom-section-content > div .wdt-listings-utils-item-holder a, .wdt-dashbord-recent-activites-holder .wdt-dashbord-recent-activites-content p a, .wdt-dashbord-recent-activites-holder .wdt-dashbord-recent-activites-content p strong, .wdt-dashbord-container .wdt-my-listings-container .wdt-listing-details h5 a, .wdt-dashbord-container .wdt-my-listings-container .wdt-listing-dashboard-owner a, .wdt-dashbord-container .wdt-my-listings-container .wdt-listing-details .wdt-mylisting-options-container > a[data-tooltip]:after, .wdt-dashbord-inbox-listing-conversation-wrapper ul.wdt-dashbord-inbox-conversation-list li>span:before, .wdt-listings-dates-container [class*="date-container"] > :not(:last-child), .wdt-listings-dates-container [class*="date-container"] > div:not(:last-child) > :not(:last-child), .wdt-listings-post-dates-container.type1 .wdt-listings-post-date-container span, .wdt-listings-dates-container.type2 [class*="date-container"] > span, p.login-remember input[type="checkbox"]:checked~label:before, .wdt-login-title h2, .wdt-claim-form-container .wdt-claimform-secure-note > span { color:'.$primary_color.'}';

		// Pagination Color
		$output .= '.wdt-pagination.wdt-ajax-pagination ul.page-numbers li span, .wdt-pagination.wdt-ajax-pagination ul.page-numbers li a:hover, .wdt-pagination.wdt-ajax-pagination .prev-post a:hover, .wdt-pagination.wdt-ajax-pagination .next-post a:hover { color:'.$primary_color.'}';

		// Border Color
		$output .= '.wdt-pagination.wdt-ajax-pagination .prev-post a, .wdt-pagination.wdt-ajax-pagination .next-post a, .wdt-pagination.wdt-ajax-pagination ul.page-numbers li span, .wdt-pagination.wdt-ajax-pagination ul.page-numbers li a { border-color:'.$primary_color.'}';

		// BG Color
		$output .= '.wdt-dashbord-container .woocommerce-orders-table th, .wdt-pagination.wdt-ajax-pagination .prev-post a, .wdt-pagination.wdt-ajax-pagination .next-post a, .wdt-pagination.wdt-ajax-pagination ul.page-numbers li a { background-color:'.$primary_color.'}';


		// Single Page Shortcode Color

		$output .= '.wdt-packages-item-wrapper .wdt-packagelist-features li:before, .wdt-listings-average-rating-container .wdt-listings-average-rating-holder span, .wdt-listings-average-rating-container .wdt-listings-average-rating-overall, .wdt-listings-featured-item-container.type1 > span, .wdt-listings-dates-container.type2 .wdt-listings-post-date-container span, .wdt-listings-nearby-places-container .wdt-listings-nearby-places-item .wdt-listings-nearby-places-content .wdt-listings-nearby-places-title, .wdt-listings-nearby-places-container .wdt-listings-nearby-places-item .wdt-listings-nearby-places-content .wdt-listings-nearby-places-ratings:before, .wdt-listings-nearby-places-container .wdt-listings-nearby-places-item .wdt-listings-nearby-places-content .wdt-listings-nearby-places-distance:before, .wdt-listings-nearby-places-container .wdt-listings-nearby-places-item .wdt-listings-nearby-places-content .wdt-listings-nearby-places-address:before, .wdt-listings-contactdetails-container.type2 .wdt-listings-contactdetails-list > li span, .wdt-announcement-listing-holder.booknow span, .wdt-announcement-listing-holder.booknow a:hover, .wdt-announcement-listing-holder.contactus:hover h2, .wdt-announcement-listing-holder.contactus:hover p, .wdt-claim-form-container .wdt-claim-form .wdt-claim-form-title, .wdt-listings-dates-container.type4 [class*="date-container"] span, .wdt-listings-countdown-timer-container.type2 .wdt-countdown-wrapper .wdt-countdown-icon-wrapper, .wdt-listings-countdown-timer-container.type2 .wdt-listings-countdown-timer-holder .wdt-listings-countdown-timer-holder .wdt-listings-countdown-timer-notice span,[class*="wdt-listings-utils-"] .wdt-listings-price-container .wdt-listings-price-item ins, .wdt-yelp-places-container .wdt-yelp-places-item .wdt-yelp-places-content .wdt-yelp-places-title, .wdt-yelp-places-container .wdt-yelp-places-item .wdt-yelp-places-content .wdt-yelp-places-ratings:before, .wdt-yelp-places-container .wdt-yelp-places-item .wdt-yelp-places-content .wdt-yelp-places-distance:before, .wdt-yelp-places-container .wdt-yelp-places-item .wdt-yelp-places-content .wdt-yelp-places-address:before, div[class*="-output-data-container"] .wdt-ajax-load-image .wdt-loader-inner, .wdt-sf-fields-holder input[type="text"] ~ span:not(.wdt-detect-location), .wdt-listings-contactform input ~ span, .wdt-listings-contactform textarea ~ span,.wdt-comment-form-fields-holder p input[type="text"]~span, .wdt-comment-form-fields-holder p input[type="email"]~span, .wdt-comment-form-fields-holder p textarea~span, .wdt-listings-item-wrapper:hover .wdt-listings-item-top-section .wdt-listings-featured-item-container a, form.lidd_mc_form .lidd_mc_input input[type="text"]~span:not(#lidd_mc_total_amount-error):before, form.lidd_mc_form .lidd_mc_input input[type="text"]~span:not(#lidd_mc_total_amount-error):after, .wdt-user-list-item.type3 .wdt-user-sociallinks-list li a, .wdt-user-list-item.type3 .wdt-user-contactdetails-list li a, .wdt-listings-contactdetails-container.type2 .wdt-listings-contactdetails-list > li a, .wdt-listings-item-wrapper.type7 .wdt-listings-item-bottom-section-content .wdt-listings-item-bottom-right-content .wdt-listings-utils-item-holder a, .wdt-listings-features-box-container.type3 .wdt-listings-features-box-item .wdt-listings-features-box-item-icon, .wdt-announcement-listing-holder.announcement, [class*="wdt-listings-utils-"] .wdt-listings-taxonomy-container .wdt-listings-taxonomy-list li a:hover span[class*="wdt"], .wdt-listings-item-wrapper.type6 .wdt-listings-item-bottom-section .wdt-listings-utils-item-holder a.wdt-listings-utils-favourite-item, .wdt-listings-attachment-holder.type1 .wdt-listings-attachment-box-item span, #loginform .wdt-login-field-item input~span, .wdt-listings-claim-form>.wdt-listings-claim-form-item input~span, .wdt-listings-claim-form>.wdt-listings-claim-form-item textarea~span, .wdt-listings-comment-list-holder .comment-body .comment-meta .comment-author b.fn, .wdt-listings-claim-form>.wdt-listings-claim-form-item input#wdt-claimform-verification-file+label, .wdt-listings-social-share-container .wdt-listings-social-share-list li a:hover, .wdt-listings-social-share-container .wdt-listings-social-share-list li a:hover, .wdt-user-list-item.type3 .wdt-user-item-meta-data .wdt-listings-social-share-container .wdt-listings-social-share-list li a:hover { color:'.$primary_color.'}';

		// Shortcode BG Color

		$output .= 'ul.wdt-dashboard-menus li a span, .wdt-dashboard-user-package-details .wdt-dashboard-package-detail span.wdt-dashboard-package-detail-value, .wdt-dashboard-user-package-details .wdt-dashboard-package-detail span.wdt-dashboard-package-detail-title, .wdt-dashbord-container .wdt-dashbord-section-holder .wdt-dashbord-statistics-counter-label, .custom-button-style, .wdt-dashbord-container .wdt-my-listings-container .wdt-listing-details .wdt-mylisting-options-container > a, .wdt-dashbord-section-holder-content ul.wdt-dashbord-reviews-listing-options-wrapper li:hover, .wdt-dashbord-section-holder-content ul.wdt-dashbord-reviews-listing-options-wrapper li.wdt-active, .wdt-dashboard-container .woocommerce-button.view, .wdt-listings-item-wrapper.type1:hover .wdt-listings-item-bottom-section-content .custom-button-style.wdt-listing-view-details:hover, .wdt-listings-item-wrapper.type2 .wdt-listings-item-bottom-section-content > div.wdt-listings-item-bottom-pricing-holder .custom-button-style:hover,	.wdt-dashbord-container .wdt-packages-container .wdt-packages-item-wrapper .wdt-packagelist-details .wdt-item-status-details .wdt-proceed-button a.custom-button-style, .wdt-packages-item-wrapper.type1 .wdt-packagelist-view-details-button:hover, .wdt-packages-item-wrapper.type1 .wdt-item-status-details .wdt-proceed-button .custom-button-style:hover,  .wdt-packages-item-wrapper.type1 .wdt-item-status-details .wdt-proceed-button .added_to_cart:hover, .wdt-packages-item-wrapper.type2 .wdt-item-status-details .custom-button-style:hover, .wdt-packages-item-wrapper.type2 .wdt-item-status-details .added_to_cart:hover, .wdt-packages-item-wrapper.type3 .wdt-item-status-details .custom-button-style:hover, .wdt-packages-item-wrapper.type3 .wdt-item-status-details .added_to_cart:hover, .wdt-packages-item-wrapper.type3 .wdt-packagelist-view-details .custom-button-style:hover, .wdt-packages-item-wrapper.type3 .wdt-item-status-details .wdt-purchased:hover, .wdt-listings-item-wrapper.type3 .wdt-listings-item-bottom-section a.custom-button-style:hover, .wdt-listings-item-wrapper.type4 .wdt-listings-item-bottom-section>div.wdt-listings-item-bottom-pricing-holder .custom-button-style:hover, .wdt-sf-orderby-field-holder ul.wdt-sf-orderby-list li a:hover, .wdt-sf-orderby-field-holder ul.wdt-sf-orderby-list li a.active, .wdt-sf-fields-holder .ui-widget-content .ui-state-default.ui-state-active, .wdt-sf-fields-holder.wdt-sf-features-field-holder .ui-widget.ui-widget-content, div[class*="-output-data-container"] .wdt-swiper-pagination-holder .wdt-swiper-bullet-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover, div[class*="-output-data-container"] .wdt-swiper-pagination-holder .wdt-swiper-bullet-pagination.swiper-pagination-bullets .swiper-pagination-bullet.swiper-pagination-bullet-active, .wdt-sf-others-field-holder div.wdt-sf-others-list:hover, .wdt-dashbord-ads-addnew-wrapper ul.wdt-addtocart-purhcase-preview-wrapper li:not(.duration):not(.total-amount) span.active, .wdt-marker-container, .wdt-marker-addition-info.wdt-marker-addition-info-categoryimage .wdt-marker-addition-info-categoryimage-inner, table.wdt-my-incharges-table thead tr th, .wdt-dashbord-load-buyer-listings-content table thead tr th, table.wdt-custom-table > tbody:first-child > tr > th, .wdt-dashbord-ads-listing table.wdt-custom-table tbody tr td:last-child a:hover, .wdt-listings-item-wrapper .wdt-listings-item-top-section .wdt-listings-featured-item-container a, .wdt-listings-item-wrapper .wdt-listings-item-top-section .wdt-listings-item-ad-section, .wdt-listings-item-wrapper.type3 .wdt-listings-item-top-section div.wdt-listings-item-ad-section:before, .wdt-listings-item-wrapper.type3 .wdt-listings-item-top-section div.wdt-listings-featured-item-container a:before, .wdt-listings-item-wrapper.type8 .wdt-listings-item-top-section .wdt-listings-featured-item-container a, .wdt-listings-item-wrapper.type7 .wdt-listings-item-top-section .wdt-listings-item-ad-section span:before, table.wdt-user-claimed-posts-table thead tr th, .wdt-dashbord-load-favourite-listings-content table th, .wdt-dashbord-inbox-listing-conversation-wrapper ul.wdt-dashbord-inbox-conversation-list li a.wdt-dashbord-inbox-conversation-reply-loader, .wdt-dashbord-inbox-listing-conversation-wrapper ul.wdt-dashbord-inbox-conversation-list li .wdt-dashbord-inbox-conversation-reply-wrapper .wdt-inbox-conversation-reply-submit, .wdt-dashbord-ads-addnew-wrapper ul.wdt-addtocart-purhcase-preview-wrapper li.duration span, .wdt-dashbord-ads-addnew-wrapper ul.wdt-addtocart-purhcase-preview-wrapper li.total-amount span, .wdt-listings-contactform a.wdt-contactform-submit-button, .wdt-listings-floorplan-top-section .wdt-listings-floorplan-expand-bottom-section, .wdt-listings-author-container[class*=swiper-container-] .wdt-listings-swiper-pagination-holder.type1 .wdt-swiper-bullet-pagination .swiper-pagination-bullet-active, .wdt-listings-item-wrapper.type2 .wdt-listings-item-top-section div.wdt-listings-item-ad-section:after, .wdt-listings-item-wrapper.type2 .wdt-listings-item-top-section div.wdt-listings-item-ad-section:before, .wdt-listings-item-wrapper.type3.wdt-list:hover .wdt-listings-item-top-section div.wdt-listings-item-ad-section:after, .wdt-listings-item-wrapper.type3.wdt-list:hover .wdt-listings-item-top-section div.wdt-listings-featured-item-container:after, .wdt-listing-taxonomy-item.type7:hover .wdt-listing-taxonomy-starting-price:after, .wdt-listings-social-share-container.type2.active .wdt-listings-social-share-item-icon > span, .wdt-listings-social-share-container.type2:hover .wdt-listings-social-share-item-icon > span, .wdt-listings-item-wrapper.type5 .wdt-listings-item-top-section div.wdt-listings-taxonomy-container ul.wdt-listings-taxonomy-list li>a:before, .wdt-sf-pricerange-field-holder .ui-widget.ui-widget-content .ui-widget-header, .wdt-comment-form-fields-holder .comment-form-media span:hover input#wdt_media + label, .wdt-user-list-item.type3 .wdt-user-item-meta-data .wdt-listings-social-share-container.active .wdt-listings-social-share-item-icon span, .wdt-user-list-item.type3 .wdt-user-item-meta-data .wdt-listings-social-share-container .wdt-listings-social-share-item-icon:hover span, .wdt-user-list-item.type3 .wdt-user-item-meta-data .wdt-listings-utils-favourite .wdt-listings-utils-favourite-author:hover span, .wdt-listings-nearby-places-container .wdt-listings-nearby-places-item .wdt-listings-nearby-places-image .wdt-listings-nearby-places-icon, form.lidd_mc_form .lidd_mc_input input[type="submit"], .comment-form .wdt-comment-form-fields-holder p.form-submit input[type="submit"], .logged-in .wdt-listings-comment-list-holder p.form-submit input[type="submit"], #loginform .login-submit input[type="submit"], .wdt-listings-features-box-container.type1 .wdt-listings-features-box-item .wdt-listings-features-box-item-title:first-child:before, .wdt-announcement-listing-holder.contactus span, .wdt-listings-claim-wrapper .wdt-listings-claim-item, .wdt-dashbord-container .wdt-my-listings-container .wdt-listing-details .wdt-mylisting-options-container>a[data-tooltip]:before, .wdt-sf-fields-holder .ui-widget-content .ui-widget-header, .wdt-listings-post-dates-container.type2 .wdt-listings-post-date-container span, .wdt-listings-attachment-holder.type2 .wdt-listings-attachment-box-item span, .wdt-listings-dates-container.type3 [class*="date-container"] span, .wdt-listings-utils-container .wdt-listings-utils-item .wdt-listings-date-container:hover>span, .wdt-dashbord-ads-listing table.wdt-custom-table tbody tr td:last-child>*, .wdt-announcement-listing-holder.announcement h2:after, .wdt-announcement-listing-holder.announcement a,  .wdt-listings-item-wrapper.type8 .wdt-listings-item-bottom-section ul.wdt-listings-taxonomy-list li a { background-color:'.$primary_color.'}';

		// Single Page Shortcode Bg

		$output .= '.wdt-listings-sociallinks-container.type1 .wdt-listings-sociallinks-list li a, .wdt-listings-sociallinks-container.type2 .wdt-listings-sociallinks-list li a, .wdt-listings-sociallinks-container.type3 .wdt-listings-sociallinks-list li a, .wdt-listings-sociallinks-container.type7 .wdt-listings-sociallinks-list li a, .wdt-listings-sociallinks-container.type4 .wdt-listings-sociallinks-list li a:hover, .wdt-listings-sociallinks-container.type5 .wdt-listings-sociallinks-list li a:hover, .wdt-listings-sociallinks-container.type6 .wdt-listings-sociallinks-list li a:hover, .wdt-listings-sociallinks-container.type8 .wdt-listings-sociallinks-list li a:hover, .wdt-listings-average-rating-container.type2 .wdt-listings-average-rating-holder, .wdt-listings-average-rating-container.type2 .wdt-listings-average-rating-overall, .wdt-listings-average-rating-container.type2 .wdt-listings-average-rating-reviews-count, .wdt-listings-average-rating-container.type3 .wdt-listings-average-rating-overall, .wdt-listings-mls-number-container span, .wdt-listings-mls-number-container.type3 > span:before, .wdt-listings-featured-item-container.type2 > span, .wdt-listings-featured-item-container.type3 > span:before, .wdt-listings-price-container.type1 .wdt-listings-price-label-holder ins:before, .wdt-listings-price-container.type1 .wdt-listings-price-label-holder del:before, .wdt-listings-price-container.type3 .wdt-price-currency-symbol, .wdt-listings-price-container.type3 .wdt-listings-price-label-holder .wdt-listings-price-item, .wdt-listings-dates-container.type4 .wdt-listings-post-date-container, .wdt-listings-dates-container.type5 .wdt-listings-post-date-container a:hover, .wdt-listings-contactdetails-request-container.type1 > a, .wdt-listings-contactdetails-request-container.type2 > a:hover, .wdt-listings-address-directions, .wdt-listings-utils-container .wdt-listings-utils-item .wdt-listings-date-container:hover span:before, .wdt-listings-utils-container .wdt-listings-utils-item .wdt-listings-contactdetails-list li:hover span, .wdt-listings-utils-container .wdt-listings-utils-item .wdt-listings-utils-favourite-item:hover span, .wdt-listings-utils-container .wdt-listings-utils-item .wdt-listings-utils-pageview-item:hover span, .wdt-listings-utils-container .wdt-listings-utils-item .wdt-listings-utils-print-item:hover span, .wdt-listings-utils-container .wdt-listings-utils-item .wdt-listings-social-share-item-icon:hover span, .wdt-listings-utils-container .wdt-listings-utils-item .wdt-listings-social-share-container.active .wdt-listings-social-share-item-icon span, .wdt-listings-utils-container .wdt-listings-utils-item .wdt-listings-average-rating-container:hover .wdt-listings-average-rating-overall span, .wdt-listings-utils-container .wdt-listings-utils-item .wdt-listings-featured-item-container:hover span:before, .wdt-listings-utils-container .wdt-listings-taxonomy-container .wdt-listings-taxonomy-list li:hover a span:before, [class*="wdt-listings-utils-"] .wdt-listings-dates-container [class*="-date-container"]:hover span:before, .wdt-listings-contactdetails-container.type1 .wdt-listings-contactdetails-list > li:hover span, .wdt-announcement-listing-holder.booknow a, .wdt-announcement-listing-holder.booknow:hover span, .wdt-claim-form-container .wdt-listings-claim-form .wdt-claimform-submit-button, .wdt-listings-dates-container.type5 [class*="date-container"], .wdt-listings-countdown-timer-container.type1 .wdt-countdown-wrapper .wdt-countdown-icon-wrapper, .wdt-listings-countdown-timer-container.type1 .wdt-listings-countdown-timer-holder .wdt-listings-countdown-timer-notice, .wdt-listings-attachment-holder.type4 .wdt-listings-attachment-box-item, .wdt-listings-attachment-holder.type5 .wdt-listings-attachment-box-item a:hover, .wdt-listings-image-gallery-container .wdt-swiper-bullet-pagination.swiper-pagination-bullets .swiper-pagination-bullet.swiper-pagination-bullet-active, .swiper-pagination-progressbar .swiper-pagination-progressbar-fill, .wdt-swiper-scrollbar .swiper-scrollbar-drag, .wdt-listings-image-gallery-container .wdt-listings-swiper-pagination-holder .wdt-swiper-fraction-pagination, .wdt-listings-media-videos-container .wdt-swiper-bullet-pagination.swiper-pagination-bullets .swiper-pagination-bullet.swiper-pagination-bullet-active, .swiper-pagination-progressbar .swiper-pagination-progressbar-fill, .wdt-swiper-scrollbar .swiper-scrollbar-drag, .wdt-listings-media-videos-container .wdt-listings-swiper-pagination-holder .wdt-swiper-fraction-pagination, .wdt-listings-media-videos-container.swiper-container div[class*="wdt-swiper-arrow-pagination"].type1 a[class*="wdt-swiper-arrow-"]:after, .wdt-sf-others-field-holder div.wdt-sf-others-list div.active, .ui-datepicker th, .single-wdt_packages .wdt-payment-details a.added_to_cart, .wdt-sf-fields-holder .ui-state-default, .wdt-sf-fields-holder .ui-widget-content .ui-state-default, .wdt-listings-taxonomy-container.type3 li a span.wdt-listings-taxonomy-image, .wdt-listings-taxonomy-container.type5 .wdt-listings-taxonomy-list li a:before, .wdt-listings-post-dates-container.type4 .wdt-listings-post-date-container, .wdt-listings-claim-form>.wdt-listings-claim-form-item input#wdt-claimform-verification-file:hover+label { background-color:'.$primary_color.'}';

		// Shortcode Border Color

		$output .= '.wdt-listings-item-wrapper.type2 .wdt-listings-item-bottom-section-content > div.wdt-listings-item-bottom-pricing-holder .custom-button-style:hover, .wdt-listings-item-wrapper.type3 .wdt-listings-item-bottom-section a.custom-button-style:hover, .wdt-packages-item-wrapper.type1 .wdt-packagelist-view-details-button:hover, .wdt-packages-item-wrapper.type1 .wdt-item-status-details .wdt-proceed-button .custom-button-style:hover,  .wdt-packages-item-wrapper.type1 .wdt-item-status-details .wdt-proceed-button .added_to_cart:hover, .wdt-sf-orderby-field-holder ul.wdt-sf-orderby-list li a:hover, .wdt-sf-orderby-field-holder ul.wdt-sf-orderby-list li a.active, .wdt-sf-fields-holder .ui-widget-content .ui-state-default.ui-state-active,
		.wdt-sf-others-field-holder div.wdt-sf-others-list div:hover, .wdt-sf-others-field-holder div.wdt-sf-others-list div.active, .wdt-dashbord-ads-listing table.wdt-custom-table tbody tr td:last-child a:hover, .wdt-sf-fields-holder input[type="text"]~span:not(.wdt-detect-location), form.lidd_mc_form .lidd_mc_input input[type="text"] ~ span:not(#lidd_mc_total_amount-error) { border-color:'.$primary_color.'}';

		// Single Page Shortcode Border Color

		$output .= '.wdt-listings-sociallinks-container.type4 .wdt-listings-sociallinks-list li a, .wdt-listings-sociallinks-container.type5 .wdt-listings-sociallinks-list li a, .wdt-listings-sociallinks-container.type6 .wdt-listings-sociallinks-list li a, .wdt-listings-sociallinks-container.type4 .wdt-listings-sociallinks-list li a:hover, .wdt-listings-sociallinks-container.type5 .wdt-listings-sociallinks-list li a:hover, .wdt-listings-sociallinks-container.type6 .wdt-listings-sociallinks-list li a:hover, .wdt-listings-sociallinks-container.type8 .wdt-listings-sociallinks-list li a, .wdt-listings-contactdetails-request-container.type2 > a, .wdt-listings-contactdetails-request-container.type3 > a, .wdt-announcement-listing-holder.booknow, .wdt-announcement-listing-holder.contactus, .wdt-announcement-listing-holder.contactus a, .wdt-announcement-listing-holder.booknow  a, .wdt-claim-form-container .wdt-listings-claim-form textarea:focus, .wdt-listings-dates-container.type4 [class*="date-container"], .wdt-listings-image-gallery-holder .wdt-listings-image-gallery-thumb-container .wdt-listings-image-gallery-thumb .swiper-slide-active:after, .wdt-listings-media-videos-holder .wdt-listings-media-videos-thumb-container .wdt-listings-media-videos-thumb .swiper-slide-active:after, .wdt-listings-media-videos-container.swiper-container div[class*="wdt-swiper-arrow-pagination"].type1 a[class*="wdt-swiper-arrow-"]:last-child:before, .wdt-listings-media-videos-container.swiper-container div[class*="wdt-swiper-arrow-pagination"].type1 a[class*="wdt-swiper-arrow-"]:first-child:before { border-color:'.$primary_color.'}';

		// Shortcode Box Shadow Color

		$output .= '.wdt-packages-item-wrapper.type2 .wdt-item-status-details .custom-button-style, .wdt-packages-item-wrapper.type2 .wdt-item-status-details .added_to_cart, .wdt-packages-item-wrapper.type3 .wdt-item-status-details .custom-button-style, .wdt-packages-item-wrapper.type3 .wdt-item-status-details .added_to_cart, .wdt-packages-item-wrapper.type3 .wdt-packagelist-view-details .custom-button-style, .wdt-packages-item-wrapper.type3 .wdt-item-status-details .wdt-purchased,
		.wdt-listings-item-wrapper.type3:not(.wdt-list) .wdt-listings-item-top-section div.wdt-listings-item-ad-section:before { box-shadow: inset 0 0 0 2px '.$primary_color.' }';

		// Remove this set, if you wish to change the Default values as like your theme

		$output .= 'input[type="submit"], button, input[type="button"], input[type="reset"] { background-color:'.$primary_color.'}';
		$output .= 'input[type="text"]:focus, input[type="text"]:active, input[type="password"]:focus, input[type="password"]:active, input[type="email"]:focus, input[type="email"]:active, input[type="url"]:focus, input[type="url"]:active, input[type="tel"]:focus, input[type="tel"]:active, input[type="number"]:focus, input[type="number"]:active, input[type="range"]:focus, input[type="range"]:active, input[type="date"]:focus, input[type="date"]:active, textarea:focus, textarea:active, input.text:focus, input.text:active, input[type="search"]:focus, input[type="search"]:active { border-color:'.$primary_color.'}';


		// Secondary
		$output .= '.wdt-dashbord-container .wdt-my-listings-container .wdt-listing-dashboard-status:after, .wdt-dashbord-container .wdt-packages-container .wdt-packages-item-wrapper .wdt-packagelist-details .wdt-item-status-details .wdt-purchased:after, .wdt-dashbord-container .wdt-packages-container .wdt-packages-item-wrapper .wdt-packagelist-details .wdt-item-status-details .wdt-active:after, .wdt-listings-item-wrapper:hover .wdt-listings-item-bottom-section-content>div .wdt-listings-price-container .wdt-listings-price-label-holder ins, ul.wdt-dashboard-menus li a:hover, ul.wdt-dashboard-menus li a.wdt-active, .wdt-packages-item-wrapper .wdt-item-status-details .wdt-purchased:after, .wdt-listings-item-wrapper.type3 .wdt-listings-item-bottom-section-content > div .wdt-listings-price-container .wdt-listings-price-label-holder ins, .wdt-listings-item-wrapper.type5 .wdt-listings-item-bottom-section a.custom-button-style:hover, .wdt-custom-login li a:hover, .wdt-listing-taxonomy-item .wdt-listing-taxonomy-meta-data h3 a:hover, .wdt-listings-comment-list-holder .commentlist li.comment .comment-body .reply a.comment-reply-link:hover, .wdt-packages-item-wrapper .wdt-packagelist-details > h5 a:hover,
		.wdt-listings-item-wrapper .wdt-listings-item-bottom-section-content .wdt-listings-item-title a:hover, .wdt-listings-item-wrapper.type7 .wdt-listings-item-bottom-section .wdt-listings-item-title a:hover, .wdt-user-list-item .wdt-user-item-meta-data h4 a:hover, .wdt-user-list-item.type2 .wdt-user-contactdetails-list li a:hover, .wdt-user-list-item.type3 .wdt-user-sociallinks-list li a:hover, .wdt-user-list-item.type3 .wdt-user-contactdetails-list li a:hover, .wdt-listings-item-wrapper.type3 .wdt-listings-taxonomy-container li a:hover, .wdt-listings-taxonomy-container.type3 li a:hover, .wdt-listings-contactdetails-container.type2 .wdt-listings-contactdetails-list > li a:hover, p.tpl-forget-pwd a:hover, .wdt-listings-item-wrapper.type5 .wdt-listings-item-bottom-section-content > div .wdt-listings-utils-item-holder a:hover, .wdt-listings-item-wrapper.type7 .wdt-listings-item-bottom-section-content .wdt-listings-item-bottom-right-content .wdt-listings-utils-item-holder a:hover, .wdt-listings-item-wrapper.type1.has-post-thumbnail .wdt-listings-item-top-section .wdt-listings-item-top-section-content .wdt-listings-utils-item-holder > div a:hover, .wdt-dashbord-recent-activites-holder .wdt-dashbord-recent-activites-content p a:hover, .wdt-dashbord-container .wdt-my-listings-container .wdt-listing-details h5 a:hover, .wdt-dashbord-container .wdt-my-listings-container .wdt-listing-dashboard-owner a:hover, .wdt-listings-item-wrapper.type5 .wdt-listings-item-bottom-section-content > div .wdt-listings-utils-item-holder [class*="wdt-listings-utils-"] a.wdt-listings-utils-favourite-item span:hover, .wdt-listings-item-wrapper.type1:not(.has-post-thumbnail) .wdt-listings-item-top-section .wdt-listings-item-top-section-content .wdt-listings-utils-item-holder .wdt-listings-utils-item:first-child>* span:hover, .wdt-listings-item-wrapper.type1:not(.has-post-thumbnail) .wdt-listings-item-top-section .wdt-listings-item-top-section-content .wdt-listings-utils-item-holder > div a:hover, .wdt-listings-item-wrapper.type1.has-post-thumbnail .wdt-listings-item-top-section .wdt-listings-item-top-section-content > div.wdt-listings-utils-item-holder .wdt-listings-utils-item > * > span:hover, div[class*="-apply-isotope"] div[class*="-isotope-filter"] a.active-sort, div[class*="-apply-isotope"] div[class*="-isotope-filter"] a:hover,
		.comment-form .wdt-comment-form-fields-holder>p.comment-form-cookies-consent input[type="checkbox"]:checked~label:before { color:'.$secondary_color.'}';

		// Single Page Shortcode color Ends

		$output .= 'ul.wdt-dashboard-menus li a:hover span, ul.wdt-dashboard-menus li a.wdt-active span, .wdt-dashbord-container .wdt-my-listings-container .wdt-listing-dashboard-status, .wdt-dashbord-container .wdt-my-listings-container .wdt-listing-details .wdt-mylisting-options-container > a:hover, .custom-button-style:hover, .wdt-dashbord-container .wdt-packages-container .wdt-packages-item-wrapper .wdt-packagelist-details .wdt-item-status-details .wdt-purchased, .wdt-dashbord-container .wdt-packages-container .wdt-packages-item-wrapper .wdt-packagelist-details .wdt-item-status-details .wdt-active, .wdt-dashboard-container .woocommerce-button.view:hover, .wdt-dashbord-container .wdt-packages-container .wdt-packages-item-wrapper .wdt-packagelist-details .wdt-item-status-details .wdt-proceed-button a.custom-button-style:hover, .wdt-packages-item-wrapper .wdt-item-status-details .wdt-purchased, .wdt-listings-item-wrapper .wdt-listings-features-box-item>div.wdt-listings-features-box-item-title:first-child:before, .wdt-listings-item-wrapper.type6:hover .wdt-listings-item-bottom-section .wdt-listings-utils-item-holder a.wdt-listings-utils-favourite-item, .wdt-user-list-item.type1 .wdt-user-sociallinks-list li a:hover, div[class*="-output-data-container"] .wdt-swiper-pagination-holder .wdt-swiper-bullet-pagination.swiper-pagination-bullets .swiper-pagination-bullet, .wdt-dashbord-inbox-listing-conversation-wrapper ul.wdt-dashbord-inbox-conversation-list li a.wdt-dashbord-inbox-conversation-reply-loader:hover, .wdt-dashbord-inbox-listing-conversation-wrapper ul.wdt-dashbord-inbox-conversation-list li .wdt-dashbord-inbox-conversation-reply-wrapper .wdt-inbox-conversation-reply-submit:hover, .wdt-listings-contactform a.wdt-contactform-submit-button:hover, .wdt-listings-floorplan-top-section .wdt-listings-floorplan-expand-bottom-section:hover, .wdt-announcement-listing-holder a:hover, .single-wdt_packages .wdt-payment-details a.added_to_cart:hover, form.lidd_mc_form .lidd_mc_input input[type="submit"]:hover, .comment-form .wdt-comment-form-fields-holder p.form-submit input[type="submit"]:hover, .logged-in .wdt-listings-comment-list-holder p.form-submit input[type="submit"]:hover, #loginform .login-submit input[type="submit"]:hover, .wdt-listings-contactdetails-request-container.type2 > a:hover, .wdt-listings-claim-wrapper .wdt-listings-claim-item:hover, .wdt-listings-post-dates-container.type2 .wdt-listings-post-date-container:hover span, .wdt-dashbord-ads-listing table.wdt-custom-table tbody tr td:last-child > a:hover, .wdt-claim-form-container .wdt-listings-claim-form .wdt-claimform-submit-button:hover, .dismissButton:hover:hover, .wdt-announcement-listing-holder.announcement a:hover, .wdt-listings-item-wrapper.type4:hover .wdt-listings-item-top-section .wdt-listings-featured-item-container a:hover { background-color:'.$secondary_color.'}';

		// Single Page Shortcode BG Color

		$output .= '.wdt-listings-sociallinks-container.type1 .wdt-listings-sociallinks-list li a:hover, .wdt-listings-sociallinks-container.type2 .wdt-listings-sociallinks-list li a:hover, .wdt-listings-sociallinks-container.type3 .wdt-listings-sociallinks-list li a:hover, .wdt-listings-sociallinks-container.type7 .wdt-listings-sociallinks-list li a:hover, .wdt-listings-average-rating-container.type3, .wdt-listings-mls-number-container.type3 > span, .wdt-listings-featured-item-container.type3 > span, .wdt-listings-price-container.type2 .wdt-listings-price-label-holder .wdt-listings-price-item, .wdt-listings-dates-container.type4 .wdt-listings-post-date-container:hover, .wdt-listings-contactdetails-request-container > a:hover, .wdt-listings-contactdetails-request-container.type3 > a:hover, .wdt-listings-address-directions:hover, .wdt-listings-contactdetails-container.type2 .wdt-listings-contactdetails-list > li:hover span, .wdt-claim-form-container .wdt-listings-claim-form .wdt-claimform-submit-button:hover, .wdt-listings-dates-container.type3 [class*="date-container"]:hover span, .wdt-listings-dates-container.type4 [class*="date-container"]:hover, .wdt-listings-dates-container.type5 [class*="date-container"]:hover, .wdt-listings-attachment-holder.type2 .wdt-listings-attachment-box-item:hover span, .wdt-listings-attachment-holder.type3 .wdt-listings-attachment-box-item:hover, .wdt-listings-attachment-holder.type4 .wdt-listings-attachment-box-item:hover,.wdt-listings-image-gallery-container .wdt-swiper-bullet-pagination.swiper-pagination-bullets .swiper-pagination-bullet, .wdt-listings-media-videos-container .wdt-swiper-bullet-pagination.swiper-pagination-bullets .swiper-pagination-bullet, .wdt-listings-item-wrapper.type4 .wdt-listings-item-top-section .wdt-listings-item-top-section-content > div.wdt-listings-utils-item-holder .wdt-listings-utils-item > *:hover, .wdt-listings-item-wrapper.type4 .wdt-listings-item-top-section .wdt-listings-item-top-section-content > div:not(.wdt-listings-taxonomy-container) a.wdt-listings-utils-favourite-item:hover span,
		.wdt-listings-item-wrapper.type6:not(.has-post-thumbnail):hover .wdt-listings-item-top-section div.wdt-listings-item-ad-section, .wdt-listings-item-wrapper.type6:not(.has-post-thumbnail):hover .wdt-listings-item-top-section div.wdt-listings-featured-item-container a { background-color:'.$secondary_color.'}';

		$output .= '.wdt-listings-author-container[class*=swiper-container-] .wdt-listings-author-details-holder:hover, .wdt-announcement-listing-holder.contactus a:hover, .wdt-listings-contactdetails-request-container.type2 > a:hover, .wdt-listings-contactdetails-request-container.type3 > a:hover, .wdt-listings-attachment-holder.type3 .wdt-listings-attachment-box-item:hover, .wdt-listings-dates-container.type4 [class*="date-container"]:hover, .dismissButton:hover:hover, .wdt-listings-features-box-container:not(.listing).type7 .wdt-listings-features-box-item,
		.wdt-listings-post-dates-container.type3 .wdt-listings-post-date-container, .wdt-listings-attachment-holder.type3 .wdt-listings-attachment-box-item { border-color:'.$secondary_color.'}';

		// Shortcode Box Shadow Color

		$output .= '.wdt-listings-item-wrapper.type3:not(.wdt-list):hover .wdt-listings-item-top-section div.wdt-listings-featured-item-container a { box-shadow: inset 0 0 0 0px '.$secondary_color.' }';

		// Remove this set, if you wish to change the Input values as like your theme
		$output .= 'input[type="submit"]:hover, button:hover, input[type="button"]:hover, input[type="reset"]:hover { background-color:'.$secondary_color.'}';


		// Tertiary

		$output .= '.wdt-packages-item-wrapper.type2 .wdt-packagelist-view-details .custom-button-style, .wdt-listings-item-wrapper.type6:not(.has-post-thumbnail) .wdt-listings-item-bottom-section .wdt-listings-utils-item-holder, .wdt-listings-item-wrapper.type2 .wdt-listings-item-top-section .wdt-listings-featured-item-container a:before, .wdt-listings-item-wrapper.type5:hover .wdt-listings-item-top-section .wdt-listings-featured-item-container:before, .single-wdt_packages .wdt_packages>img, .wdt-listings-item-wrapper.type1 .wdt-listings-item-top-section .wdt-listings-item-top-section-content .wdt-listings-utils-item-holder>div a:hover, .wdt-listings-item-wrapper.type5:hover .wdt-listings-item-top-section .wdt-listings-featured-item-container a:before, p.login-remember input[type="checkbox"]~label:before,
		.wdt-listings-item-wrapper.type6 .wdt-listings-item-bottom-section .wdt-listings-taxonomy-list li a span { color:'.$tertiary_color.'}';

		$output .= '.wdt-packages-item-wrapper h5:before, .wdt-listings-item-wrapper.type1:hover .wdt-listings-item-bottom-section-content .custom-button-style.wdt-listing-view-details, .wdt-listings-item-wrapper.type4 .wdt-listings-item-bottom-section>div.wdt-listings-item-bottom-pricing-holder .custom-button-style, .wdt-listings-item-wrapper.type4 .wdt-listings-item-top-section .wdt-listings-item-top-section-content>div a, .wdt-listings-item-wrapper.type4 .wdt-listings-item-top-section .wdt-listings-item-top-section-content>div.wdt-listings-utils-item-holder .wdt-listings-utils-item>*, .wdt-listings-item-wrapper.type6:not(.has-post-thumbnail):hover .wdt-listings-item-bottom-section .wdt-listings-utils-item-holder a.wdt-listings-utils-favourite-item, .wdt-sf-pricerange-field-holder > div > div[class*="-handle"], .wdt-sf-features-field-holder > div > div[class*="-handle"], .wdt-sf-features-field-holder .ui-widget.ui-widget-content .ui-widget-header, .wdt-swiper-arrow-pagination a:hover, .wdt-marker-addition-info.wdt-marker-addition-info-totalviews, .wdt-marker-addition-info.wdt-marker-addition-info-averageratings, .wdt-marker-addition-info.wdt-marker-addition-info-startdate, .wdt-marker-addition-info.wdt-marker-addition-info-distance, .wdt-listing-taxonomy-item.type7 .wdt-listing-taxonomy-starting-price:after, .wdt-listings-item-wrapper:hover .wdt-listings-item-top-section .wdt-listings-item-ad-section, .wdt-listings-item-wrapper:hover .wdt-listings-item-top-section .wdt-listings-featured-item-container a, .wdt-listings-item-wrapper.type7 .wdt-listings-item-top-section .wdt-listings-item-ad-section, .wdt-listings-item-wrapper.type7 .wdt-listings-item-top-section .wdt-listings-featured-item-container, .wdt-listings-item-wrapper.type3 .wdt-listings-item-top-section div.wdt-listings-item-ad-section:after, .wdt-listings-item-wrapper.type3 .wdt-listings-item-top-section div.wdt-listings-featured-item-container a:after, .wdt-listings-item-wrapper.type3:hover .wdt-listings-item-top-section div.wdt-listings-item-ad-section:before, .wdt-listings-item-wrapper.type3:hover .wdt-listings-item-top-section div.wdt-listings-featured-item-container a:before, .wdt-listings-floorplan-top-section, .wdt-listings-contactdetails-request-container.type3 > a, .wdt-listings-contactdetails-container.type2 .wdt-listings-contactdetails-list > li span, .wdt-announcement-listing-holder.contactus:hover, .wdt-listings-dates-container.type4 [class*="date-container"], .wdt-listings-countdown-timer-container.type2 .wdt-listings-countdown-timer-holder .wdt-listings-countdown-timer-notice span, .wdt-listings-attachment-holder.type2 .wdt-listings-attachment-box-item:hover span, .wdt-listings-image-gallery-container .wdt-listings-swiper-pagination-holder .wdt-swiper-progress-pagination, .wdt-listings-image-gallery-container .wdt-listings-swiper-pagination-holder .wdt-swiper-scrollbar, .wdt-listings-media-videos-container .wdt-listings-swiper-pagination-holder .wdt-swiper-progress-pagination, .wdt-listings-media-videos-container .wdt-listings-swiper-pagination-holder .wdt-swiper-scrollbar, .wdt-packages-item-wrapper:before, .single-wdt_packages .wdt-packagelist-items h3:before, .single-wdt_packages .wdt-payment-details .wdt-item-status-details>span, .wdt-listings-item-wrapper.type2:hover .wdt-listings-item-top-section div.wdt-listings-item-ad-section:after, .wdt-listings-item-wrapper.type2:hover .wdt-listings-item-top-section div.wdt-listings-item-ad-section:before, .wdt-sf-fields-holder.wdt-sf-pricerange-field-holder .ui-widget.ui-widget-content, .wdt-listing-taxonomy-item.type6 .wdt-category-total-items a:hover, .wdt-comment-form-fields-holder input#wdt_media+label, .wdt-user-list-item.type3 .wdt-user-contactdetails-list li:hover span, .wdt-user-list-item.type3 .wdt-user-item-meta-data .wdt-listings-social-share-container.active .wdt-listings-social-share-list, .wdt-listings-features-box-container.type5 .wdt-listings-features-box-item, .wdt-announcement-listing-holder, .wdt-listings-item-wrapper.type4 .wdt-listings-item-top-section .wdt-listings-item-top-section-content > div:not(.wdt-listings-taxonomy-container) a.wdt-listings-utils-favourite-item span, .wdt-listings-item-wrapper.type6 .wdt-listings-item-bottom-section .wdt-listings-utils-item-holder a.wdt-listings-utils-favourite-item span:hover, .wdt-sf-fields-holder .ui-widget.ui-widget-content, .wdt-dashbord-section-holder-content ul.wdt-dashbord-inbox-listing-messages-wrapper li.active, .wdt-dashbord-section-holder-content ul.wdt-dashbord-inbox-listing-messages-wrapper li:hover, .wdt-listings-business-hours-container .wdt-listings-business-hours-currenttime, .wdt-listings-claim-form > .wdt-listings-claim-form-item input#wdt-claimform-verification-file + label { background-color:'.$tertiary_color.'}';

		$output .= '.wdt-listings-item-wrapper, .wdt-listings-item-wrapper.type1 .wdt-listings-item-bottom-section-content > div.wdt-listings-item-bottom-right-content, .wdt-packages-item-wrapper, .wdt-listings-item-wrapper.type4 .wdt-listings-item-bottom-section .wdt-listings-item-bottom-section-content .wdt-listings-item-title, .wdt-packages-item-wrapper.type1 .wdt-packagelist-view-details-button, .wdt-packages-item-wrapper.type1 .wdt-item-status-details .wdt-proceed-button .custom-button-style, .wdt-packages-item-wrapper.type2>ul.wdt-packagelist-features, .wdt-packages-item-wrapper.type3 .wdt-packagelist-details,  .wdt-packages-item-wrapper.type1 .wdt-item-status-details .wdt-proceed-button .added_to_cart, .wdt-listings-item-wrapper.type4 .wdt-listings-features-box-container>div:not(:last-child), .wdt-listings-item-wrapper.type5 .wdt-listings-item-bottom-section-content > div .wdt-listings-utils-item .wdt-listings-utils-totalimages-item a, .wdt-listings-item-wrapper.type7 .wdt-listings-item-bottom-section-content .wdt-listings-item-bottom-right-content .wdt-listings-utils-item-holder .wdt-listings-utils-item .wdt-listings-utils-totalimages-item a, .wdt-listing-taxonomy-item.type4, .wdt-user-list-item.type3, .wdt-user-list-item.type3 .wdt-user-contactdetails-list li span, .wdt-swiper-arrow-pagination a, .wdt-marker-info-box .wdt-listings-map-item-wrapper.type3 .wdt-listings-item-bottom-section .wdt-listings-item-title, .wdt-listing-taxonomy-item.type4 .wdt-listing-taxonomy-starting-price, .wdt-listings-item-wrapper.type7 .wdt-listings-item-bottom-section-content .wdt-listings-item-bottom-left-content .wdt-listings-post-dates-container, .wdt-dashbord-recent-activites-holder .wdt-dashbord-recent-activites-content p, .wdt-listings-comment-list-holder .comment-body, .comment-form .wdt-comment-form-fields-holder .wdt-ratings-holder, .wdt-marker-info-box .wdt-listings-map-item-wrapper.type3 .wdt-listings-item-bottom-section .wdt-listings-item-title, .wdt-listings-floorplan-box-container .wdt-listings-floorplan-box-item, .wdt-listings-business-hours-container, .wdt-listings-business-hours-container .wdt-listings-business-hours-status, .wdt-listings-business-hours-container .wdt-listings-business-hours-list li, .wdt-listings-dates-container.type1, .wdt-listings-dates-container.type1 > div:not(:last-child), .wdt-listings-dates-container.type1 .wdt-listings-business-hours-list, .wdt-listings-dates-container.type1 .wdt-listings-business-hours-list li, .wdt-listings-image-gallery-thumb-container .wdt-listings-image-gallery-thumb .swiper-slide:hover:after, .wdt-listings-media-videos-thumb-container .wdt-listings-media-videos-thumb .swiper-slide:hover:after, .single-wdt_packages .wdt-payment-details .wdt-item-status-details, .wdt-dashbord-container .wdt-my-listings-container .wdt-listing-item-wrapper, .wdt-sf-fields-holder .ui-widget-content .ui-state-default.ui-state-hover, .wdt-listing-taxonomy-item.type6 .wdt-category-total-items a:hover, .wdt-user-list-item.type3 .wdt-user-item-meta-data .wdt-listings-utils-favourite, .wdt-listings-features-box-container.type4 .wdt-listings-features-box-item:not(:last-child), .wdt-listings-features-box-container.type7 .wdt-listings-features-box-item, .wdt-listings-countdown-timer-container.type2 .wdt-listings-countdown-timer-holder .wdt-listings-countdown-timer-notice,  .wdt-announcement-listing-holder.contactus, .wdt-announcement-listing-holder.contactus:hover, .wdt-dashbord-section-holder-content ul.wdt-dashbord-inbox-listing-messages-wrapper li.active, .wdt-dashbord-section-holder-content ul.wdt-dashbord-inbox-listing-messages-wrapper li:hover { border-color:'.$tertiary_color.'}';

		// Single Page Shortcode Border Color

		$output .= '.wdt-listings-nearby-places-container .wdt-listings-nearby-places-item:not(:last-child), .wdt-listings-author-container .wdt-listings-author-details-holder, .wdt-packages-item-wrapper.type2 .wdt-packagelist-details, #primary.page-with-sidebar .wdt-packages-item-wrapper.type2 .wdt-packagelist-details { border-color:'.$tertiary_color.'}';

		// Single Page Shortcode Border Color Ends

		$output .= '.wdt-listings-item-wrapper.type1 .wdt-listings-item-bottom-section-content .custom-button-style.wdt-listing-view-details, .wdt-listings-item-wrapper.type2 .wdt-listings-item-bottom-section-content > div.wdt-listings-item-bottom-pricing-holder { border-top-color:'.$tertiary_color.'}';

		$output .= '.wdt-packages-item-wrapper:hover, .wdt-packages-item-wrapper.type1:hover .wdt-packagelist-view-details-button, .wdt-packages-item-wrapper.type1:hover .wdt-item-status-details .wdt-proceed-button .custom-button-style, .wdt-user-list-item.type1:hover, .wdt-listings-taxonomy-container.type7 li a:hover, .wdt-listings-author-container .wdt-listings-author-details-holder:hover { box-shadow: 0 15px 30px 0 '.$tertiary_color.' }';

		$output .= '.swiper-wrapper .wdt-listings-item-wrapper:hover { box-shadow: 0 10px 20px 0 '.$tertiary_color.' }';

		$output .= '.comment-form .wdt-comment-form-fields-holder, .wdt-listings-contactform, .logged-in .wdt-listings-comment-list-holder .comment-form, .wdt-listings-nearby-places-container .wdt-listings-nearby-places-item .wdt-listings-nearby-places-image,
		.wdt-yelp-places-container .wdt-yelp-places-item .wdt-yelp-places-image, .wdt-listings-taxonomy-container.type7 li a:hover { box-shadow: 0 0 30px 0 '.$tertiary_color.' }';

		$output .= '
		.wdt-packages-item-container.swiper-wrapper .wdt-packages-item-wrapper:hover, .wdt-packages-item-container.swiper-wrapper .wdt-packages-item-wrapper.type1:hover .wdt-item-status-details .wdt-proceed-button .custom-button-style, .wdt-packages-item-container.swiper-wrapper .wdt-packages-item-wrapper.type1:hover .wdt-packagelist-view-details-button { box-shadow: 0 0 20px 0 '.$tertiary_color.' }';

		$output .= '.wdt-user-list-item.type3 .wdt-user-contactdetails-list li span, .wdt-listings-author-container .wdt-listings-author-details-holder .wdt-listings-author-details .wdt-listings-contactdetails-list li span { box-shadow: inset 0 0 0 2px '.$tertiary_color.' }';

		// RGBA Colors

		$output .= '.wdt-listings-media-videos-container.swiper-container div[class*="wdt-swiper-arrow-pagination"].type2 > a[class*="wdt-swiper-arrow"] { background-color:rgba('.$primary_color_rgba.', 0.5)}';

		$output .= '.wdt-listings-media-videos-container.swiper-container div[class*="wdt-swiper-arrow-pagination"].type2>a[class*="wdt-swiper-arrow"]:hover, .wdt-listings-image-gallery-container.swiper-container div[class*="wdt-swiper-arrow-pagination"].type2>a[class*="wdt-swiper-arrow"]:hover { background-color:rgba('.$primary_color_rgba.', 0.6)}';

		$output .= '.wdt-listings-image-gallery-container.swiper-container div[class*="wdt-swiper-arrow-pagination"].type2>a[class*="wdt-swiper-arrow"] { background-color:rgba('.$primary_color_rgba.', 0.15)}';

		// $output .= '.wdt-listings-item-wrapper.type6 .wdt-listings-item-bottom-section .wdt-listings-item-bottom-section-content .wdt-listings-item-bottom-left-content { background-color:rgba('.$primary_color_rgba.', 0.8)}';


		$output .= '.wdt-listings-item-wrapper.type6.has-post-thumbnail .wdt-listings-item-top-section .wdt-listings-feature-image-holder:before,
		.wdt-listings-item-wrapper.type6.has-post-thumbnail .wdt-listings-item-top-section .wdt-listings-image-gallery .swiper-slide:before {
		background-color:rgba('.$primary_color_rgba.', 0.8)}';

		$output .= '.lidd_mc_details .lidd_mc_summary p:not(:last-child), .lidd_mc_details .lidd_mc_results p, .wdt-listing-taxonomy-item.type4:hover, .wdt-listing-taxonomy-item.type4:hover .wdt-listing-taxonomy-starting-price, .wdt-user-list-item.type2 .wdt-user-image img, .wdt-dashbord-section-holder-content ul.wdt-dashbord-inbox-listing-messages-wrapper li:hover span, .wdt-dashbord-section-holder-content ul.wdt-dashbord-inbox-listing-messages-wrapper li.active span { border-color:rgba('.$secondary_color_rgba.', 0.2)}';

		$output .= '.wdt-listings-features-box-container:not(.listing).type7 .wdt-listings-features-box-item,
		.wdt-listings-post-dates-container.type3 .wdt-listings-post-date-container, .wdt-listings-attachment-holder.type3 .wdt-listings-attachment-box-item {
		background-color:rgba('.$secondary_color_rgba.', 0.3)}';

		$output .= '.wdt-dashbord-container .wdt-packages-container .wdt-packages-item-wrapper:hover, .wdt-dashbord-container .wdt-my-listings-container .wdt-listing-item-wrapper:hover { background-color:rgba('.$tertiary_color_rgba.', 0.135)}';

		$output .= '.lidd_mc_details, .wdt-listing-taxonomy-item.type4:hover, .wdt-listings-nearby-places-container:hover .wdt-listings-nearby-places-item .wdt-listings-nearby-places-image { background-color:rgba('.$tertiary_color_rgba.', 0.5)}';


		wp_register_style ( 'wdt-skin', false );
		wp_add_inline_style( 'wdt-skin', $output );

		wp_enqueue_style ( 'wdt-skin' );

	}

	add_action( 'wp_enqueue_scripts', 'wdt_generate_skin_colors', 30 );

}

?>